/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)ks_glue.c	1.18 95/11/23 Sun Microsystems"

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/xv_xrect.h>

#include <skip_proto.h>
#include <skip_types.h>
#include <skip_ioctl.h>
#include <skip_lib.h>
#include "ks_ui.h"
#include "ks_glue.h"

#ifdef SYSV
#include <sys/systeminfo.h>
#endif

boolean_t				animating = B_FALSE;
static Server_image			key_images[MAX_IMAGES];
static int				max_images = 0;
char					*progname;
struct itimerval			timer;
const int				delay = 600;	/* delay in ms */
boolean_t				single_frame = B_TRUE;

static char *				r_host;
static char *				r_mkeyid;
static int				r_nsid;
static int				r_version;

/*
 * animation callback
 */
static void
animate()
{
	static int	frame = 0;

	if (!animating || (max_images == 0)) {
		return;
	}
	xv_set(Ks_key_stat_win->key_icon,
			PANEL_LABEL_IMAGE, key_images[frame],
			NULL);

	frame++;

	if (frame == max_images) {
		frame = 0;
		animating = B_FALSE;
		if (!single_frame) {
			xv_set(Ks_key_stat_win->key_icon,
				PANEL_LABEL_IMAGE, key_images[frame],
				NULL);
		}
	}
	if (single_frame) {
		animating = B_FALSE;
	}
}

/*
 * load animation rasters
 */
static 
load_images()
{
	Xv_Screen				screen;
	Display					*display;
	int					screen_no;
	int					i, x, y, w, h, d;
	char					fn[STRSZ], *bw_suffix;

	display = (Display *) xv_get(Ks_key_stat_win->key_stat_win, XV_DISPLAY);
	screen = xv_get(Ks_key_stat_win->key_stat_win, XV_SCREEN);
	screen_no = xv_get(screen, SCREEN_NUMBER);

	bw_suffix = DefaultDepth(display, screen_no) < 8 ? "_bw" : "";

	for (i = 0; i < MAX_IMAGES; i++) {
		sprintf(fn, "Loading image %d\n", i + 1);
		(void) xv_set(Ks_key_stat_win->key_stat_win,
			FRAME_LEFT_FOOTER, fn,
			NULL);
		sprintf(fn, "%d%s.ras", i, bw_suffix);
		key_images[i] = load_raster(fn, &w, &h, &d);
		if (key_images[i] == NULL) {
			break;
		}
	}
	max_images = i;
	(void) xv_set(Ks_key_stat_win->key_stat_win,
			FRAME_LEFT_FOOTER, "",
			NULL);
}

/*
 * show key change animation
 */
static void
key_change()
{
	animating = B_TRUE;
}

/*
 * make window active/inactive
 */
static void
window_active(boolean_t active)
{
	(void) xv_set(Ks_key_stat_win->encrypt_keys,
					PANEL_VALUE, active ? "1" : "0",
					NULL);
	(void) xv_set(Ks_key_stat_win->key_icon,
					PANEL_INACTIVE, !active,
					NULL);
	(void) xv_set(Ks_key_stat_win->kij_alg,
					PANEL_INACTIVE, !active,
					NULL);
	(void) xv_set(Ks_key_stat_win->kp_alg,
					PANEL_INACTIVE, !active,
					NULL);
	(void) xv_set(Ks_key_stat_win->percent,
					PANEL_INACTIVE, !active,
					NULL);
}

/*
 * process interval timer
 */
static Notify_value
update_status()
{
	char			label[STRSZ];
	static unsigned int	last_ekp_len;
	static char		last_ekp_buf[MAXVARSZ];
	static unsigned char	last_kij_alg, last_kp_alg;
	static int		last_percent, last_max_obytes,
				last_nencrypt_keys, last_ndecrypt_keys;
	int			percent;
	ioctl_key_status_t	key_status = { 0 };
	char			*if_name = skip_default_if();


	if (animating) {
		animate();
		return (NOTIFY_DONE);
	}

	key_status.params.r_nsid = r_nsid;

	if (skip_host_to_addr(r_host, &key_status.params.ip_addr) < 0) {
		fprintf(stderr, "Hostname to IP address conversion failed.\n");
		exit(1);
	}

	if (key_status.params.r_nsid == 0) {
		/*
		 * Fill in the key id with host IP address
		 */
		key_status.params.r_mkeyid.len = sizeof(struct in_addr);
		memcpy((char *) key_status.params.r_mkeyid.buf,
				(char *) &key_status.params.ip_addr, 
				key_status.params.r_mkeyid.len);
	} else {

		if (skip_s_to_keyid(r_mkeyid, key_status.params.r_nsid,
					&key_status.params.r_mkeyid) < 0) {
			fprintf(stderr, "Invalid receiver NSID/key id.\n");
			exit(1);
		}
	}


	/*
	 * get encryption/decryption  key status for this host
	 */
	if (skip_get_key_status(if_name, &key_status) < 0) {
		return;
	}

	if (key_status.count_out != last_nencrypt_keys) {
		sprintf(label, "%d", key_status.count_out);
		(void) xv_set(Ks_key_stat_win->encrypt_keys,
			PANEL_VALUE, label,
			NULL);
		window_active(key_status.count_out > 0);
		last_nencrypt_keys = key_status.count_out;
	}


	if (last_ndecrypt_keys != key_status.count_in) {
		sprintf(label, "%d", key_status.count_in);
		(void) xv_set(Ks_key_stat_win->decrypt_keys,
			PANEL_VALUE, label,
			NULL);
		last_ndecrypt_keys = key_status.count_in;
	}


	if (key_status.params.kij_alg != last_kij_alg) {
		(void) xv_set(Ks_key_stat_win->kij_alg,
			PANEL_VALUE,
				skip_kij_alg_to_name(
					key_status.params.kij_alg,
					r_version),
			NULL);
		last_kij_alg = key_status.params.kij_alg;
	}

	if (key_status.params.kp_alg != last_kp_alg) {
		(void) xv_set(Ks_key_stat_win->kp_alg,
			PANEL_VALUE,
				skip_kp_alg_to_name(
					key_status.params.kp_alg,
					r_version),
			NULL);
		last_kp_alg = key_status.params.kp_alg;
	}

	if (key_status.max_obytes != last_max_obytes) {
		sprintf(label, "%dk", key_status.max_obytes / 1024);
		(void) xv_set(Ks_key_stat_win->percent,
			PANEL_MAX_TICK_STRING, label,
			NULL);
		last_max_obytes = key_status.max_obytes;
	}

	percent = (skip_bytes_percent(&key_status) / 10) * 10;
	if (percent != last_percent) {
		(void) xv_set(Ks_key_stat_win->percent,
			PANEL_VALUE, percent,
			NULL);
		last_percent = percent;
	}

	if (!((key_status.ekp_len == last_ekp_len) && 
		(memcmp((caddr_t) key_status.ekp_buf,
			(caddr_t) last_ekp_buf, key_status.ekp_len) == 0))) {
		key_change();
		memcpy(last_ekp_buf, key_status.ekp_buf, last_ekp_len);
		last_ekp_len = key_status.ekp_len;
	}

	return (NOTIFY_DONE);
}

static void
usage(char *who)
{
	fprintf(stderr, "usage: %s "
			"<hostname> <SKIP version> <NSID> <key id>\n", who);
	exit(1);
}

/*
 * main entry point
 */
void
init(int argc, char *argv[])
{
	char		label[STRSZ];

	if (argc != 5) {
		usage(argv[0]);
	}

	memset((char *)&timer, 0, sizeof(timer));

	progname = argv[0];

	skip_var_init(progname);

	(void) xv_set(Ks_key_stat_win->key_stat_win, XV_SHOW, TRUE, NULL);

	notify_dispatch();

	load_images();

	if (strrchr(argv[0], '/') != NULL) {
		progname = strrchr(argv[0], '/') + 1;
	} else {
		progname = argv[0];
	}


	sprintf(label, "SKIP Key status (%s)", argv[1]);
	xv_set(Ks_key_stat_win->key_stat_win,
			XV_LABEL, label,
			NULL);

	r_host		= argv[1];
	r_version	= atoi(argv[2]);
	r_nsid		= atoi(argv[3]);
	r_mkeyid	= argv[4];

	if (max_images > 0) {
		xv_set(Ks_key_stat_win->key_icon,
			PANEL_LABEL_IMAGE, key_images[0],
			NULL);
	}

	if (delay) {
		timer.it_value.tv_usec = delay * 1000;
		timer.it_interval.tv_usec = delay * 1000;
		notify_set_itimer_func(Ks_key_stat_win->key_stat_win,
			update_status, ITIMER_REAL, &timer, NULL);
	}

}
