/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)CertInfoList.C	1.5 96/04/18"

#include "CertInfoList.h"
#include "Time.h"


void CertInfoList::insert(const CertInfo& a)
{
	l.insert(a);
}

void CertInfoList::append(const CertInfo& a)
{
	l.append(a);
}

int CertInfoList::length()
{
	return l.length();
}

void CertInfoList::clear()
{
	l.clear();
}

CertInfo* CertInfoList::first()
{
	return l.first();
}

CertInfo* CertInfoList::next()
{
	return l.next();
}

void CertInfoList::delete_current()
{
	l.delete_current();
}

//  Produce a Bstream representation of a list of CertInfo's:
//

Bstream CertInfoList::encode()
{
	Bstream ret;

	Bstream::putint(ret, l.length());

	for (CertInfo* p = first(); p; p = next())
		ret += p->encode();

	return ret;
}

int CertInfoList::decode(Bstream& in, CertInfoList& out)
{
	int len;

	out.clear();

	if (Bstream::getint(in, &len))
		return 1;				// list damaged

	while (len > 0) {
		CertInfo item;

		if (CertInfo::decode(in, item)) {	// decode failure
			out.clear();
			return 1;
		}

		out.append(item);

		len--;
	}

	return 0;
}

//  Search the list of certificates for a likely one which is valid now
//  leave cursor pointing to this elem so we can delete_current it

CertInfo* CertInfoList::find_valid_cert(AuthPolicy& auth)
{
	CertInfo *p;
	CertInfo *ret = NULL;
	u_long begin_time = 0;

	for (p = first(); p; p = next())
		if (p->check_valid(auth) == NULL) {
			u_long t;

			t = p->cert->skip_notvalidbefore();

			if (t > begin_time) {
				ret = p;
				begin_time = t;
			}
		}

	return ret;
}

//  Add a certificate to a CertInfoList
//  If an existing certificate in the list has the same validity
//  period, replace it.

void CertInfoList::add_cert(const CertInfo& item)
{
	CertInfo *p;
	u_long start, end;

	if (item.cert == 0)
		return;

	start = item.cert->skip_notvalidbefore();
	end = item.cert->skip_notvalidafter();

	for (p = first(); p; p = next()) {
		if (p->cert == 0)
			continue;

		if (start == p->cert->skip_notvalidbefore() &&
		    end   == p->cert->skip_notvalidafter())
			break;
	}

	if (p)
		*p = item;
	else
		append(item);
}

