;; -*- Scheme -*-
;;
;; $Id: avl-tree05.scm,v 1.1 1998/03/16 07:57:16 foner Exp $

;;------------

(require 'avl-tree:merge-insert)

;;------------

;;+doc
;; procedure: avl-tree:overwriting-insert
;; arguments: tree key unwrap-key <? make-element
;; signature: forall a,b,c
;;    => avl-tree[a,b,c] x c x (c -> a) x (a x a -> bool) x (() -> c)
;;    -> avl-tree[a,b,c]
;;
;; Addn element with the given KEY to TREE.  If an element with the same
;; key is already in the tree, it is overwritten.  MAKE-ELEMENT is called
;; to generate the element.
;;
;; Assume the tree T already contains { "phone" -> 8066, "fax" -> "6280" }
;; then the following :-
;;
;; > (avl-tree:overwriting-insert
;;     t "phone" (lambda (id) id) string<? (lambda () 6270))
;; 
;; will insert the new phone number to give { "phone" -> 6270, fax -> "6280" }
;;-doc

(define avl-tree:overwriting-insert
  (lambda (t e uk <? me)
    (avl-tree:merge-insert t e uk <? (lambda (o) (me)) me)))

;; eof
