; -*- Scheme -*-
;
; $Id: char-set-17.scm,v 1.1 1998/03/16 07:57:53 foner Exp $

;+doc
; procedure: char-set->list
; arguments: char-set
; signature: char-set -> [char]
;
; Converts the character set into a list of characters.
; Note the order of the list is not specified, the only guarantee is
; that an element in the char-set will only appear once in the set.
;-doc

(define char-set->list
  (lambda (s)
    (let loop ((i (- char-set::vector-size 1))
	       (r '()))
      (if (zero? i)
	  r
	  (loop (- i 1)	(if (char-set::at s i)
			    (cons (integer->char (- i 1)) r)
			    r))))))

; eof
