; -*- Scheme -*-
;
; $Id: char-set-18.scm,v 1.1 1998/03/16 07:57:53 foner Exp $

;+doc
; procedure: char-set->string
; arguments: char-set
; signature: char-set -> string
;
; Convert the char set into a string
; The order of the characters in the resulting string is unspecified,
; the only guarantee is that each element of the set will only appear
; once in the string.
;-doc

(define char-set->string
  (lambda (s)
    (let* ((ss (char-set:size s))
	   (r (make-string ss)))
      (let loop ((i (- char-set::vector-size 1)) ((j (- ss 1))))
	(if (zero? i)
	    r
	    (if (char-set::at s i)
		(begin
		  (string-set! r j (integer->char (- i 1)))
		  (loop (- i 1) (- j 1)))
		(loop (- i 1) j)))))))

; eof
