; -*- Scheme -*-
;
; $Id: pathname17.scm,v 1.1 1998/03/16 07:59:12 foner Exp $

(require 'pathname::update)

;+doc
; procedure: pathname:+name
; arguments: pathname name
; signature: pathname pathname:name -> pathname
; 
; Create new pathname consisting of PATHNAME with its name overridden
; with NAME.
;-doc

(define pathname:+name
  (let ((id (lambda (x) x)))
    (lambda (pathname name)
      (pathname::update pathname id id id (lambda (_) name) id id))))

; eof
