;;; +++ It'd be nice to combine all three of these (and their callers) in some nice way.  Later.
(define (identity:description-link id)
  (list
   "<a href = \"identity.html?"
   (ui:bytes->hex id)
   "\">"
   (identity:description id)
   "</a>"))

(define (identity:href id)
  (list
   "<a href = \"identity.html?"
   (ui:bytes->hex id)
   "\">"))

;;; This one is designed to be called by format, -and- uses a smaller font.  Called in 
;;; attestions:generate-one-attestation-row, but defined here to keep all the similar functions together.
;;; Also includes possible extra text after the description.
(define (identity:description-link-small id opinion)
  (format nil "<a href=\"identity.html?~A\"><font size=\"-1\">~A~A</font></a>"
	  (ui:bytes->hex id)
	  (identity:description id)
	  opinion))
;;; ---

(define (identity:index-href)
  (identity:href (ui:hex->bytes ui:index)))

(define (identity:index-description)
  (identity:description (ui:hex->bytes ui:index)))

(define (identity:index-description-link)
  (identity:description-link (ui:hex->bytes ui:index)))

(define (identity:compose-link index)
  (list "<a href = \"compose.html?"
	index
	"\">"))

(define (identity:general-info)
  (let* ((id (ui:hex->bytes ui:index))
	 (last-seen (identity:last-seen id))
	 (contact-msg
	  (cond ((zero? last-seen)
		 (format nil "Never contacted."))
		(t
		 (format nil "Last contacted at ~A.<br>Last contacted on ~A."
			 (date-string last-seen)
			 (ui:literal (identity:get-path id)))))))
    (format nil "~A<p>~A message~:P not yet delivered.<p>"
	    contact-msg
	    (length (identity:message-list id)))))

(define (identity:recent-messages)
  (let ((id (ui:hex->bytes ui:index)))
    (list
     "<h2>Recent messages</h2>"
     (ui:pretty-html-list
      (map (lambda (message-spec)
	     (let ((msg (messages:get-message (cadr message-spec))))
	       (list "<a href = \"read-message.html?"
		     (cadr message-spec)
		     "\">"
		     (ui:literal (messages:title msg))
		     ": \""
		     (if (> (string-length (messages:text msg))
                            23)
                         (list (ui:line-literal (substring
                                                 (messages:text msg) 0 20))
                               "...\"")
                         (list (ui:line-literal (messages:text msg))
                               "\""))
		     "</a>")))
	   (identity:most-recent-from id 5))))))
