(define (interest-okay:add-interest)
  (cond ((= 1 (compare:collection-length *interface:provided-interest*))
	 (define doc (compare:collection-ref *interface:provided-interest* 0))
	 (compare:scale-document doc *interests:spec-factor*)
	 (compare:remove-document *interface:provided-interest* 0)
	 (if (interests:add-interest doc)
"<p>I have noted your interest in my database. You can specify more
information about your interests via the <a href =
\"interests.html\">Interests</a> menu item.</p>"
"<p>Your interest will be added to the database when I finish processing
the other files. At that time I may ask if this interest is the same as
one I find in your files. You can check on my progress in processing via
the <a href = \"interests.html\">Interests</a> menu item, or my general
condition via the <a href = \"news.html\">News</a> menu item.</p>"))
	(t
"There is no interest currently requiring confirmation. In order to
specify one, go to the <a href = \"interests.html\">interest</a> page and
use the <b>interest description</b> option.")))
