(define (send-message:do-it)
  (if (= (string->number (ui:form-datum "seq-num")) *ui:send-seq-num*)
      (let* ((orig (if (ui:form-datum "original")
		       (messages:get-message 
			(string->number (ui:form-datum "original")))
		       #f))
	     (topic (if orig 
			(messages:topic orig)
			(compare:export-document 
			 (compare:centroid
			  (string->number (ui:form-datum "local-topic")))
			 50)))
	     (to-cluster (if (ui:form-datum "to-one")
			     #f
			     (if orig
				 (messages:local-interest orig)
				 (string->number (ui:form-datum "local-topic")))))
	     (ref (if orig
		      (messages:unique-id orig)
		      #f))
	     (message (messages:make-message topic to-cluster *local-yenta-id*
					     (if (ui:form-datum "to-one")
						 (ui:hex->bytes
						  (ui:form-datum "to-one"))
						 #f)
					     (messages:next-id)
					     (ui:form-datum "title")
					     (ui:form-datum "body")
					     ref)))
	
	(messages:add-message message)
	(inc! *ui:send-seq-num*)
	'())
      "The form you submitted to send this message has been submitted before. In order to send another message, you have to reload the form."))
