#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <fist.h>
#include <cryptfs.h>

int
main(int argc, char *argv[])
{
  int fd, ret;
  unsigned char val[16];
  int temp, i;

  if (argc != 2) {
    fprintf(stderr, "Usage: %s file\n", argv[0]);
    exit(1);
  }

  fd = open(argv[1], O_RDONLY);
  if (fd < 0) {
    perror(argv[1]);
    exit(1);
  }

  printf("Enter key\n");
  for (i = 0; i < 16; i++) {
    scanf("%x", &temp);
    val[i] = (char) temp;
  }

  for (i = 0; i < 16; i++)
    printf("0x%x ", val[i]);

  ret = ioctl(fd, FIST_IOCTL_SET_KEY, val);

  close(fd);
  exit(0);
}
