/* btoa8.c: The opiebtoa8() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

        History:

	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration et al.
        Created at NRL for OPIE 2.2 from opiesubr2.c.
*/      

#include "opie_cfg.h"
#include <stdio.h>
#include "opie.h"

static char hextochar[16] = { '0', '1', '2', '3', '4', '5', 
        '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

/* Convert 8-byte binary array to hex-ascii string */
int opiebtoa8 FUNCTION((out, in), char *out AND char *in)
{
  register int i;

  if (!in || !out)
    return -1;

  for (i = 0; i < 8; i++) {
    *(out++) = hextochar[((*in) >> 4) & 0x0f];
    *(out++) = hextochar[(*in++) & 0x0f];
  }
  *out = 0;
  return 0;
}
