/* opie_conf.h.in: Various configuration-type pieces of information for OPIE.
	This version is designed to work with GNU autoconf.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

        Modified by cmetz for OPIE 2.2. Don't replace sigprocmask by ifdef.
                Added configure check for LS_COMMAND. Added setreuid/setgid
                band-aids.
        Modified at NRL for OPIE 2.2. Require /etc/shadow for Linux to use
                shadow passwords.
        Modified at NRL for OPIE 2.11. Removed version defines.
	Modified at NRL for OPIE 2.1. Fixed sigprocmask declaration.
		Gutted for autoconf. Split up for autoconf.
	Written at NRL for OPIE 2.0.
*/
/* This file should make the reader painfully aware of the need to rename
   some symbols */

/* System characteristics */

#if HAVE_ETC_SECURETTY
#ifndef DOSECURETTY
#define DOSECURETTY 1
#endif /* DOSECURETTY */
#endif	/* HAVE_ETC_SECURETTY */

/* Missing functions */

#if !HAVE_SETENV
#ifndef NEED_SETENV
#define NEED_SETENV 1
#endif /* NEED_SETENV */
#endif /* !HAVE_SETENV */

#if !HAVE_PUTENV
#ifndef NEED_PUTENV
#define NEED_PUTENV 1
#endif /* NEED_PUTENV */
#endif /* !HAVE_PUTENV */

#if !HAVE_STRERROR
#ifndef NEED_STRERROR
#define NEED_STRERROR 1
#endif /* NEED_STRERROR */
#endif /* !HAVE_STRERROR */

#if HAVE_GETUTXLINE
#ifndef DOUTMPX
#define DOUTMPX 1
#endif	/* DOUTMPX */
#define UTMPX utmpx
#else /* HAVE_GETUTXLINE */
#define UTMPX utmp
#endif /* HAVE_GETUTXLINE */

#if !HAVE_SETEUID && HAVE_SETRESUID
#define seteuid(x) setresuid(-1, x, -1)
#endif /* !HAVE_SETEUID && HAVE_SETRESUID */

#if !HAVE_SETEGID && HAVE_SETRESGID
#define setegid(x) setresgid(-1, x, -1)
#endif /* !HAVE_SETEGID && HAVE_SETRESGID */

/* Adapted from the Autoconf hypertext info pages */
#if HAVE_DIRENT_H
#include <dirent.h>
#else /* HAVE_DIRENT_H */
#define dirent direct
#if HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif /* HAVE_SYS_NDIR_H */
#if HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif /* HAVE_SYS_DIR_H */
#if HAVE_NDIR_H
#include <ndir.h>
#endif /* HAVE_NDIR_H */
#endif /* HAVE_DIRENT_H */

#if !HAVE_ATEXIT
#if HAVE_ON_EXIT
#define atexit on_exit
#else /* HAVE_ON_EXIT */
#define atexit(x)
#endif /* HAVE_ON_EXIT */
#endif /* !HAVE_ATEXIT */

#if HAVE_ETC_LOGINDEVPERM
#ifndef PERMSFILE
#define PERMSFILE "/etc/logindevperm"
#endif /* PERMSFILE */
#endif /* HAVE_ETC_LOGINDEVPERM */

#if HAVE_ETC_FBTAB
#ifndef PERMSFILE
#define PERMSFILE "/etc/fbtab"
#endif /* PERMSFILE */
#endif /* HAVE_ETC_FBTAB */

#if !HAVE_STRCHR && HAVE_INDEX
#define strchr(s,c)    index((s),(c))
#endif /* !HAVE_STRCHR && HAVE_INDEX */

#if !HAVE_STRRCHR && HAVE_RINDEX
#define strrchr(s,c)    rindex((s),(c))
#endif /* !HAVE_STRRCHR && HAVE_RINDEX */

#if !HAVE_GETCWD && HAVE_GETWD
#define getcwd(buf,t)  getwd((buf))
#endif /* !HAVE_GETCWD && HAVE_GETWD */

#if !HAVE_SYSCONF && HAVE_GETDTABLESIZE
#define sysconf(_SC_OPEN_MAX) getdtablesize()
#endif /* !HAVE_SYSCONF && HAVE_GETDTABLESIZE */

/* BSDs sometimes don't print the group w/o -g */
#ifndef LS_COMMAND
#if HAVE_LS_G_FLAG
#define LS_COMMAND "/bin/ls -lgA"
#else /* HAVE_LS_G_FLAG */
#define LS_COMMAND "/bin/ls -lA"
#endif /* HAVE_LS_G_FLAG */
#endif	/* LS_COMAND */

#ifndef MAIL_DIR
#ifdef PATH_MAIL
#define MAIL_DIR PATH_MAIL
#else /* PATH_MAIL */
#ifdef _PATH_MAIL
#define MAIL_DIR _PATH_MAIL
#else /* _PATH_MAIL */
#ifdef _PATH_MAILDIR
#define MAIL_DIR _PATH_MAILDIR
#else /* _PATH_MAILDIR */
#define MAIL_DIR "/usr/spool/mail"
#endif /* _PATH_MAILDIR */
#endif /* _PATH_MAIL */
#endif /* PATH_MAIL */
#endif /* MAIL_DIR */

#if !defined(sigmask) && !HAVE_SIGMASK && !HAVE_SIGMASK_MACRO
/* sigmask() is a handy BSD macro that is not POSIX or SYSV */
#define sigmask(m)   (1 << ((m)-1))
#endif

/* Not sure how I'll do this yet... */
#define HAVETTYSLOT 0
#if 0
#ifndef HAVETTYSLOT
#ifdef IS_A_BSD
#define HAVETTYSLOT 1	/* BSD man pages say it appeared in V7 */
#endif	/* IS_A_BSD */
#ifdef IS_A_SYSV
#define HAVETTYSLOT 0	/* But some System Vs appear to have "fixed" it */
#endif	/* IS_A_SYSV */
#endif	/* HAVETTYSLOT */
#endif /* 0 */

#if !HAVE_MEMCPY && HAVE_BCOPY
#define memcpy(dst, src, len) bcopy(src, dst, len)
#endif /* !HAVE_MEMCPY && HAVE_BCOPY */

#if !HAVE_MEMSET && HAVE_BZERO
#define memset(b, 0, len) bzero(b, len)
#endif /* !HAVE_MEMCPY && HAVE_BCOPY */

#if HAVE_SHADOW_H && HAVE_GETSPENT && HAVE_ENDSPENT
#define HAVE_SHADOW 1
#if defined(linux) && !HAVE_ETC_SHADOW 
#undef HAVE_SHADOW
#define HAVE_SHADOW 0
#endif /* defined(linux) && !HAVE_ETC_SHADOW */
#endif /* HAVE_SHADOW_H && HAVE_GETSPENT && HAVE_ENDSPENT */

#if !HAVE_GETUSERSHELL && !defined(NEED_GETUSERSHELL)
#define NEED_GETUSERSHELL 1
#endif /* !HAVE_GETUSERSHELL && !defined(NEED_GETUSERSHELL) */

#if !HAVE_ENDUSERSHELL && !defined(NEED_ENDUSERSHELL)
#define NEED_ENDUSERSHELL 1
#endif /* !HAVE_ENDUSERSHELL && !defined(NEED_ENDUSERSHELL) */

#if !HAVE_SETEUID && HAVE_SETREUID
#define seteuid(x) setreuid(-1, x)
#endif /* !HAVE_SETEUID && HAVE_SETREUID */

#if !HAVE_SETEGID && HAVE_SETREGID
#define setegid(x) setregid(-1, x)
#endif /* !HAVE_SETEGID && HAVE_SETREGID */
