/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

# pragma ident "@(#)certreq.C	1.18 96/08/06"

#include "Bstream.h"
#include "Bigint.h"

/*
 * System includes
 */
#include <skip_os.h>

#include "skipd.h"
#include "SkipCert.h"
#include "LL.h"
#include "cdp.h"
#include "skip_certbase.h"
#include "AuthPolicy.h"

AuthPolicy auth;

// This is a simple client to the certificate discovery protocol.  It takes
// a keyid, nsid and certificate site and fetches it from the specified remote
// host.


#define MAXTRIES	5


int cdp_get_cert(struct in_addr *ip_addr, u_char nsid, Bstream keyid, 
	CertInfoList& l)
{
	int sock;
	struct sockaddr_in name,recv_addr,from;
	struct timeval tv;
	int rbufsize;
	u_char buf[65535];
	fd_set f;
	int n,i;

	l.clear();

	sock=socket(AF_INET,SOCK_DGRAM,0);
	rbufsize=65535;
	(void)setsockopt(sock,SOL_SOCKET, SO_RCVBUF, 
                       (char *)&rbufsize, sizeof(rbufsize));

	if (sock < 0 ) 
		return CDP_STATUS_LOCALERR;

	name.sin_addr.s_addr=ip_addr->s_addr;
	name.sin_family=AF_INET;
	name.sin_port=htons(CDP_PORT_RESPONDER);

	recv_addr.sin_addr.s_addr=INADDR_ANY;
	recv_addr.sin_family=AF_INET;
	recv_addr.sin_port=htons(CDP_PORT_INITIATOR);

	if (bind(sock, (struct sockaddr *)&recv_addr, sizeof(recv_addr)) < 0) {
		recv_addr.sin_port=htons(0);
		bind(sock, (struct sockaddr *)&recv_addr, sizeof(recv_addr));
	}

	cdp request(CDP_INITIATE);
	request.cdp_get(nsid, keyid);
	Bstream reqstr = request.encode();

	for (i=0; i<=MAXTRIES; i++ ) {
		if (sendto(sock, (const char *)reqstr.getdatap(), 
			   reqstr.getlength(), 0, (struct sockaddr *)&name, 
			   sizeof(name))<0)  {
			close(sock);
			return CDP_STATUS_ERROR;
		}
		tv.tv_sec=5;
		tv.tv_usec=0;
		FD_ZERO(&f);
		FD_SET(sock,&f);
		n=select(sock+1,&f,NULL,NULL,&tv);
		if (n > 0)  {
			int fromlen;
			fromlen=sizeof(from);
			n=recvfrom(sock, (char *)buf,sizeof(buf),0,
				(sockaddr *)&from,&fromlen);
			break;
		}
	}
	if (i > 5) {
		close(sock);
		return CDP_STATUS_LOCALERR;
	}
	close(sock);
	
	Bstream tempstr(n, buf);
	cdp response;

	if (response.decode(tempstr))
		return -1;

	if (response.action != CDP_RESPONSE)
		return -2;

	cdp_rec *p;
	for (p = response.recs.first(); p; p = response.recs.next())
		if (p->action == CDP_REC_GETOK && p->ci.cert)
			l.append(p->ci);

	return CDP_STATUS_OK;
}


void usage(char *s){
	fprintf(stderr,"usage: %s [-d] -h server keyid\n",s);
	fprintf(stderr,"e.g: %s -h skip.incog.com c7beb122\n",s);
	exit(1);
}

main(int argc,char *argv[])
{
	int n;
	u_char nsid=1;
	Bstream cert, keyid;
	Bigint remote;
	struct in_addr *inetaddr;
	u_long i;
	struct hostent *h;
	struct remote_info rem;
	CertInfoList cert_l;

	char **p;
	char *s;
	int c;
	int decodecert=0;
	p=argv;
	p++;
	while ((c=getopt(argc,argv,"dn:h:"))!=EOF)
		switch(c) {
			case 'd':
				p++;
				decodecert=1;
				break;
			case 'n':
				p++,p++;
				nsid=atoi(optarg);
				break;
			case 'h':
				p++,p++;
				s=optarg;		
				break;
			default:
				usage(argv[0]);
		}
	if (s == NULL) {
		usage(argv[0]);
	}
	if ((argc - optind) != 1) {
		usage(argv[0]);
	}

	auth.load(SKIP_DIR);		// XXX check return value

	if (isdigit(*s)) {
		i=inet_addr(s);
		inetaddr=(struct in_addr *)&i;
	} else {
		h=gethostbyname(s);
		if (h==NULL) {
			fprintf(stderr,"Unknown Host\n");
			exit(1);
		}
		inetaddr=(struct in_addr *)h->h_addr_list[0];
	}

	keyid=Bigint_to_Bstr(Bigint(*p));
	if (keyid.getlength() != nsid_sizes[nsid]) {
		fprintf(stderr,"Size of key %d does not match size"
				"of NSID (%d)",keyid.getlength(), (int)nsid);
		exit(1);
	}
	String temp;
	if (decodecert) {
		temp=keyid.gethexstr();
		printf("keyid=%s\n",(const char *)temp);
	}
// cdp_get_cert does the actual certificate discovery 
	n = cdp_get_cert(inetaddr, nsid, keyid, cert_l);
	switch (n) {
	
		case CDP_STATUS_LOCALERR:
			fprintf(stderr,"A local error has occured\n");
			break;

		case CDP_STATUS_OK:
			if (cert_l.length() == 0) {
				fprintf(stderr, "No certificates obtained\n");
				break;
			} if (decodecert) {
				CertInfo *p;

				for (p = cert_l.first(); p; p = cert_l.next()){
					if (p->cert)
						p->cert->print();
				}
			} else {
				Bstream cert_s;
				CertInfo *p;

				p = cert_l.first();

				cert_s = p->cert->encode();

				write(1, (char *)cert_s.getdatap(),
					cert_s.getlength());
			}
			break;

		case CDP_STATUS_NOTFOUND:
			fprintf(stderr,
				"Remote server didn't have the certificate\n");
			break;
		case CDP_STATUS_ERROR:
			fprintf(stderr,
				"An error occured on the remote server\n");
			break;
		case CDP_STATUS_NONSID:
			fprintf(stderr,
				"The Remote server does not recognize NSID\n");
			break;
		default:
			fprintf(stderr,"An unknown error occured\n");
			break;
	}
}

