/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)test_key.c	1.21 96/05/03"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_ioctl.h>
#include <skip_lib.h>

#define PRINT_MESSAGE(a)	print_message(a)

extern int		errno;
int			debug = 1;

#define	MGTCSIZE	2048
#define	MGTDSIZE	2048
#define	MAX_MESSAGES	5

char			*messages[] = {
			"invalid",
			"SKIP_ENCRYPTED_PKT_KEY_REQ",
			"SKIP_ENCRYPTED_PKT_KEY_RSP",
			"SKIP_DECRYPTED_PKT_KEY_REQ",
			"SKIP_DECRYPTED_PKT_KEY_RSP",
			"SKIP_DH_CERTIFICATE_REQ",
			"SKIP_DH_CERTIFICATE_RSP",
			"SKIP_SET_LOCAL_KEYID",
			"SKIP_FLUSH_LOCAL_KEYID",
			"SKIP_SET_SUPPORTED_KIJ"
			};

/*
 * Usage report...
 */
static int
usage(char *who)
{
	fprintf(stderr, "usage: %s [-d]\n", who);
	fprintf(stderr, "-d for debug mode, key = zeroes\n");
	return(1);
}

/*
 * Print a time stamp
 */
void
print_time()
{
	char	buf[128];

	skip_time_stamp(buf);

	printf("%s: ", buf);

}

static int
set_nodeid(int fd)
{
	struct Set_local_keyid	set;
	char			hostname[MAXHOSTNAMELEN];
	struct hostent		*hp;
	char			*p_buf;
	short			idx;
	unsigned char		cnsid;


	/*
	 * Get the local host name...
	 */
	skip_hostname(hostname, MAXHOSTNAMELEN);

	hp = gethostbyname(hostname);

	if (hp == NULL) {
		fprintf(stderr, "Cannot get host information for %s\n",
			hostname);
		return(1);
	}

	/*
	 *  Set the local Master Key ID for NSID IPV4 to local IP Address
	 */
	set.msgtype	= SKIP_SET_LOCAL_KEYID;
	set.nsid	= SKIP_NSID_IPV4;
	set.mkeyid.len	= 4;
	memcpy(set.mkeyid.buf, hp->h_addr_list[0], set.mkeyid.len);

	printf("Setting Local Master Key Id 0x%08x for NSID %d...",
		(int) ntohl(*(unsigned long *)set.mkeyid.buf), set.nsid); 

	print_time();

	fflush(stdout);

	if (skip_putmsg(fd, &set, sizeof(set)) < 0) {
		if (errno == EINTR) {
			return(1);
		}
		if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
			return(1);
		}
		perror("skip_putmsg");
	}
	printf("Done\n");

	cnsid = 0x00;
	for (idx = 0; idx < 5; idx++) {
		/*
		 * Set the local Master Key ID for NSID IPV4 
		 * to a dummy value (slotting)
		 */
		set.msgtype	= SKIP_SET_LOCAL_KEYID;
		set.nsid	= SKIP_NSID_IPV4;
		set.mkeyid.len	= 4;
		set.mkeyid.buf[0] = cnsid++;
		set.mkeyid.buf[1] = cnsid++;
		set.mkeyid.buf[2] = cnsid++;
		set.mkeyid.buf[3] = cnsid++;
	
		if (idx == 3) {
			/*
		 	 * Try to set twice the same value
		 	 */
			cnsid = 0x00;
		} else {
			cnsid += 0x10;
		}

		printf("Setting Local Master Key Id 0x%08x for NSID %d...",
			(int) ntohl(*(unsigned long *)set.mkeyid.buf),
			set.nsid); 
	
		print_time();
	
		fflush(stdout);
	
		if (skip_putmsg(fd, &set, sizeof(set)) < 0) {
			if (errno == EINTR) {
				return(1);
			}
			if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
				return(1);
			}
			perror("skip_putmsg");
		}
		printf("Done\n");
	} 

	/*
	 *  Set the local Master Key ID for NSID 8 to 4 times local IP Address
	 */
	set.msgtype	= SKIP_SET_LOCAL_KEYID;
	set.nsid	= SKIP_NSID_MD5_DH_PUB;
	set.mkeyid.len	= 4;
	p_buf		= set.mkeyid.buf;

	for (idx = 0; idx < 4; idx++) {
		memcpy(p_buf, hp->h_addr_list[0], set.mkeyid.len);
		p_buf += set.mkeyid.len;
	}
	set.mkeyid.len	*= 4;

	printf("Setting Local Master Key Id for NSID %d...", set.nsid); 

	print_time();

	fflush(stdout);

	if (skip_putmsg(fd, &set, sizeof(set)) < 0) {
		if (errno == EINTR) {
			return(1);
		}
		if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
			return(1);
		}
		perror("skip_keymhr_putmsg");
	}
	printf("Done\n");

	return(0);
}

static void
print_params(skip_param_t *params)
{

	int i;

	printf("\tversion=%d, r_nsid=%d, s_nsid=%d\n",
			params->version, params->r_nsid, params->s_nsid);

	printf("\tip @ = %08x counter_n = %08x ttl = %d\n",
			(int) ntohl(params->ip_addr.s_addr),
			(int) params->counter_n, params->ttl);

	printf("\tkij_alg=%d, kp_alg=%d, mac_alg=%d, comp_alg=%d\n",
			params->kij_alg, params->kp_alg,
			params->mac_alg, params->comp_alg);

	printf("\tr_mkeyid.len=%d, s_mkeyid.len=%d\n",
		params->r_mkeyid.len, params->s_mkeyid.len);

	printf("\tReceiver Master Key ID [");
	for (i = 0; i < 4; i++ ) {
		printf("0x%x ", (unsigned char) params->r_mkeyid.buf[i]);

	}
	printf("]\n");

	printf("\tSender Master Key ID [");
	for (i = 0; i < 4; i++ ) {
		printf("0x%x ", (unsigned char) params->s_mkeyid.buf[i]);

	}
	printf("]\n");

}

static void
print_message(union skip_messages *dp)
{
	int	i;
	char	*c;

	if (dp->msgtype > MAX_MESSAGES) {
		fprintf(stderr, "Bad message id (%d) received\n", dp->msgtype);
		return;
	}

	printf("%s:\n", messages[dp->msgtype]);

	switch (dp->msgtype) {

	case SKIP_ENCRYPTED_PKT_KEY_REQ:

		print_params(&(dp->enc_req.params));
		break;

	case SKIP_ENCRYPTED_PKT_KEY_RSP:

		print_params(&dp->enc_rsp.params);
		printf("\tekp = ");
		c = dp->enc_rsp.ekp.buf;
		for (i = 0; i < dp->enc_rsp.ekp.len; i++) {
			printf("%02x ", *c++);
		}
		putchar('\n');
		printf("\tE_kp = ");
		c =  dp->enc_rsp.E_kp.buf;
		for (i = 0; i < dp->enc_rsp.E_kp.len; i++) {
			printf("%02x ", *c++);
		}
		putchar('\n');
		printf("\tA_kp = ");
		c =  dp->enc_rsp.A_kp.buf;
		for (i = 0; i < dp->enc_rsp.A_kp.len; i++) {
			printf("%02x ", *c++);
		}
		putchar('\n');
		break;

	case SKIP_DECRYPTED_PKT_KEY_REQ:

		print_params(&dp->dec_req.params);
		printf("\tekp = ");
		c = dp->dec_req.ekp.buf;
		for (i = 0; i < dp->dec_req.ekp.len; i++) {
			printf("%02x ", *c++);
		}
		putchar('\n');
		break;

	case SKIP_DECRYPTED_PKT_KEY_RSP:

		print_params(&dp->dec_rsp.params);
		printf("\tekp = ");
		c = dp->dec_rsp.ekp.buf;
		for (i = 0; i < dp->dec_rsp.ekp.len; i++) {
			printf("%02x ", *c++);
		}
		putchar('\n');
		printf("\tE_kp = ");
		c = dp->dec_rsp.E_kp.buf;
		for (i = 0; i < dp->dec_rsp.E_kp.len; i++) {
			printf("%02x ", *c++);
		}
		putchar('\n');
		printf("\tA_kp = ");
		c =  dp->dec_rsp.A_kp.buf;
		for (i = 0; i < dp->dec_rsp.A_kp.len; i++) {
			printf("%02x ", *c++);
		}
		putchar('\n');
		break;

	default:
		fprintf(stderr, "Unsupported message (%d) in PRINT_MESSAGE\n",
				dp->msgtype);
	}
}

/*
 * Generate a "pseudo Ekp"
 */
static void
write_key(char *addr, unsigned int len)
{
	if (debug) {
		/*
		 * Set a null data buffer
		 */
		memset(addr, 0, len);
		return;
	}

	/*
	 * Fill in the buffer with "random" data
	 */
	skip_fill_random(addr, len);
}

/*
 * Generate a pseudo E_kp given the remote IP address
 */
static skip_key_var_t enc_iv;
static skip_key_var_t enc_Akp;
static skip_key_var_t enc_Ekp;
static void
gen_raw_key(skip_param_t *params)
{
	int	idx;
	int 	len =0;
	char	*p = enc_iv.buf;

	/*
	 * Clean previous values..
	 */
	memset((char *) &enc_iv, 0, sizeof (skip_key_var_t));
	memset((char *) &enc_Ekp, 0, sizeof (skip_key_var_t));
	memset((char *) &enc_Akp, 0, sizeof (skip_key_var_t));

	/*
	 * Set the IV as 4 times the remote IP address
	 */
	for (idx = 0; idx < 2; idx++) {
		memcpy(p, (char *)&params->ip_addr, sizeof(params->ip_addr));
		len +=  sizeof(params->ip_addr);
		p +=  sizeof(params->ip_addr);
	}
	enc_iv.len = len;

	/*
	 * Set Ekp...
	 */
	enc_Ekp.len = 8;
	memset((char *) enc_Ekp.buf, 0x0c, enc_Ekp.len);

	/*
	 * Set Akp...
	 */
	enc_Akp.len = 16;
	memset((char *) enc_Akp.buf, 0x0e, enc_Akp.len);

	printf("gen_raw_key: Ekp lg=%d, Iv lg=%d, Akp lg =%d\n",
		 enc_Ekp.len, enc_iv.len,  enc_Akp.len);
}

static void
make_response(union skip_messages *dp, union skip_messages *response, int *size)
{
	skip_param_t	*params;

	memset((char *) response, 0, sizeof (*response));

	if (dp->msgtype > MAX_MESSAGES) {
		fprintf(stderr, "Bad message id (%d) received\n", dp->msgtype);
		return;
	}

	/*
	 * XXX - Stupid debuging values...
	 */
	dp->enc_req.params.counter_n	= 0x44997753;
	dp->enc_req.params.ttl		= 0x11223344;
	dp->dec_req.params.counter_n	= 0x44997753;
	dp->dec_req.params.ttl		= 0x11223344;

	switch (dp->msgtype) {

	case SKIP_ENCRYPTED_PKT_KEY_REQ:
		params 				= &response->enc_rsp.params;
		response->enc_rsp.msgtype	= SKIP_ENCRYPTED_PKT_KEY_RSP;
		*size 				= sizeof (response->enc_rsp);
		
		memcpy((char *) &response->enc_rsp.params,
				(char *) &dp->enc_req.params,
				sizeof(skip_param_t));

		gen_raw_key(params);

		printf("params->version = %d\n", params->version);
		printf("dp->enc_req.params->version = %d\n", 
					dp->enc_req.params.version);

		if (dp->enc_req.params.kp_alg || dp->enc_req.params.mac_alg) {
			
			if (params->version == SKIP_RAW) {
				printf("make_response: use env_iv.\n");
				response->enc_rsp.ekp.len = 0;
				KEYVARSET(response->enc_rsp.iv, enc_iv);
			} else {
				response->enc_rsp.ekp.len = 
						params->mac_alg ? 16 : 8;
				write_key(response->enc_rsp.ekp.buf, 
						response->enc_rsp.ekp.len);
				KEYVARSET(response->enc_rsp.iv,
						response->enc_rsp.ekp);
				if (params->mac_alg) {
					/*
					 * Truncate to 8 bytes...
					 */
					response->enc_rsp.iv.len = 8;
				}
			}
		}

		if (params->kp_alg) {
			if (params->version == SKIP_RAW) {
				KEYVARSET(response->enc_rsp.E_kp, enc_Ekp);
			} else {
				KEYVARSET(response->enc_rsp.E_kp,
						response->enc_rsp.ekp);
				if (params->mac_alg) {
					/*
					 * Truncate to 8 bytes...
					 */
					response->enc_rsp.E_kp.len = 8;

				}
			}
		} else  {
			response->enc_rsp.E_kp.len = 0;
		}

		if (params->mac_alg) {
			if (params->version == SKIP_RAW) {
				KEYVARSET(response->enc_rsp.A_kp, enc_Akp);
			} else {
				KEYVARSET(response->enc_rsp.A_kp,
						response->enc_rsp.ekp);
			}
		} else  {
			response->enc_rsp.A_kp.len = 0;
		}
		break;

	case SKIP_DECRYPTED_PKT_KEY_REQ:
		params 				= &response->dec_rsp.params;
		response->dec_rsp.msgtype	= SKIP_DECRYPTED_PKT_KEY_RSP;
		response->dec_rsp.params	= dp->dec_req.params;
		*size 				= sizeof (response->dec_rsp);

		gen_raw_key(params);

		KEYVARSET(response->dec_rsp.ekp, dp->dec_req.ekp);

		if (params->kp_alg) {
			if (params->version == SKIP_RAW) {
				KEYVARSET(response->dec_rsp.E_kp, enc_Ekp);
			} else {
				KEYVARSET(response->dec_rsp.E_kp,
							dp->dec_req.ekp);
				if (params->mac_alg) {
					/*
					 * Truncate to 8 bytes...
					 */
					response->dec_rsp.E_kp.len = 8;

				}
			}
		} else  {
			response->dec_rsp.E_kp.len = 0;
		}

		if (params->mac_alg) {
			if (params->version == SKIP_RAW) {
				KEYVARSET(response->dec_rsp.A_kp, enc_Akp);
			} else {
				KEYVARSET(response->dec_rsp.A_kp,
							dp->dec_req.ekp);
			}
		} else  {
			response->dec_rsp.A_kp.len = 0;
		}
		break;

	default:
		fprintf(stderr, "Unsupported message (%d) received\n",
				dp->msgtype);
		*size = 0;
	}
}

static void
process_request(int fd)
{
	char			req[MGTCSIZE], rsp[MGTCSIZE];
	int			len, size;

	printf("\nWaiting... "); fflush(stdout);

	if ((len = skip_getmsg(fd, req, MGTCSIZE)) < 0) {
		if (errno == EINTR) {
			return;
		}
		if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
			return;
		}
		perror("skip_getmsg");
	}

	print_time();
	PRINT_MESSAGE((union skip_messages *) req);

	make_response((union skip_messages *) req, (union skip_messages *) rsp,
		&size);

	print_time();
	PRINT_MESSAGE((union skip_messages *) rsp);

	printf("Responding... "); 

	print_time();

	fflush(stdout);

	if (skip_putmsg(fd, rsp, size) < 0) {
		if (errno == EINTR) {
			return;
		}
		if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
			return;
		}
		perror("putmsg");
	}
	putchar('\n');
}

/*
 * Inform SKIP driver about a  supported Kij algorithm 
 */
static void
set_kij_alg(int fd, unsigned char version, unsigned char kij_alg)
{
	struct Set_supported_kij	set;

	set.msgtype	= SKIP_SET_SUPPORTED_KIJ;
	set.version	= version;
	set.kij_alg	= kij_alg;

	printf("Setting supported kij alg=%d for version %d...\n",
							kij_alg, version);

	print_time();

	fflush(stdout);

	if (skip_putmsg(fd, &set, sizeof(set)) < 0) {
		if (errno == EINTR) {
			return;
		}
		if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
			return;
		}
		perror("skip_keymhr_putmsg");
	}
	printf("Done.\n");
}

/*
 * Flush the previous Local Master Key IDs
 */
static void
flush_localkeyid(int fd)
{
	union skip_messages sm;

	sm.msgtype = SKIP_FLUSH_LOCAL_KEYID;

	printf("Flushing previous local Master Key IDs...\n");

	print_time();

	fflush(stdout);

	if (skip_putmsg(fd, &sm, sizeof(sm)) < 0) {
		if (errno == EINTR) {
			return;
		}
		if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
			return;
		}
		perror("skip_putmsg");
	}
	printf("Done.\n");
}

int
SKIPD(int argc, char *argv[])
{
	int	c, keyfd;

 
	while ((c = getopt(argc, argv, "df:")) != EOF) {
		switch (c) { 
		case 'd': 
			debug = 1; 
			break; 
		default: 
			usage(argv[0]); 
		} 
	} 

	keyfd = skip_open_device(KEYMGR);

	if (keyfd < 0) {
		perror("skip_open_device");
		return(1);
	}

	/*
	 * Flush all previous Master Key IDs
	 */
	flush_localkeyid(keyfd);

	/*
	 * Set the local Master Key IDs
	 */
	set_nodeid(keyfd);

	/*
	 * Set the Kij algorithms supported in SunScreen mode
	 */
	set_kij_alg(keyfd, SKIP_V1, SKIP_SIMPLECRYPT);

	/*
	 * Set the Kij algorithms supported in SunScreen mode
	 */
	set_kij_alg(keyfd, SKIP_V2, SKIP_KIJ_NONE);
	set_kij_alg(keyfd, SKIP_V2, SKIP_KIJ_SIMPLECRYPT);


	/*
	 * Loop on events...
	 */
	for (;;) {
		process_request(keyfd);
	}

	/*NOTREACHED*/
	return(0);
}

