/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_wrapper.c	1.15 96/04/18 Sun Microsystems"
 
/* 
 * System includes 
 */ 
#include <skip_os.h> 
/*
#ifdef OPENPROMS
#include <sun/openprom.h>
#endif
*/
 
/* 
 * SKIP includes 
 */ 
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>
#include <skip_ioctl.h>
#include <skip_acl.h>
#include <skip_es.h>
#include <skip_if.h>


/*
 * SunOS 4.1.x loadable driver wrapper for the SKIP module
 */
extern char		skip_module_name[];

/*
 * Module linkage information for the kernel.
 */
extern int		nulldev();

static struct cdevsw skipdevsw = {
	skip_ifopen, skip_ifclose, skip_ifread, skip_ifwrite, skip_ifioctl,
	nulldev, skip_ifselect, nulldev, NULL, nulldev };

static struct vdldrv vd =
	{
		VDMAGIC_PSEUDO,
		skip_module_name,
		NULL,		/* struct dev_ops *  */
		NULL,		/* struct bdevsw *   */
		&skipdevsw,	/* struct cdevsw *   */
		0,		/* block major       */
		0,		/* pick a char major */
#ifdef sun4m
		NULL,		/* Drv_mb_ctlr 	     */
		NULL,		/* Drv_mb_driver     */
		NULL,		/* Drv_mb_device     */
		0,		/* Drv_numctlrs      */
		0		/* Drv_numdevs       */
#endif
	};
		


/*
 * This is the driver entry point routine.  Its address was specified
 * to the linker on the link command line as "-e xxxinit".
 *
 * inputs:  function code - VDLOAD, VDUNLOAD, VDSTAT.
 *	    pointer to kernel vddrv structure for this module. 
 * 	    pointer to appropriate vdioctl structure for this function.
 *	    pointer to vdstat structure (for VDSTAT only)
 *	
 * return:  0 for success.  VDLOAD function must set vdp->vdd_vdtab.
 *	    non-zero error code (from errno.h) if error.
 *
 */

extern int 		fmodcnt;
extern struct fmodsw	fmodsw[];

/*ARGSUSED*/
int
xxxinit(function_code, vdp, vdi, vds)
unsigned int function_code;
struct vddrv *vdp;
addr_t vdi;
struct vdstat *vds;
{
	register int		rc;
	extern int		skip_init(), skip_uninit();

#ifdef sun4c
	/*
	 * XXX beware GNU including the wrong <machine/pcb.h>
	 */
	if (sizeof(struct pcb) == 0x764) {
		printf("skip: error - sun4m <machine/pcb.h> has been "
			"used for this build\n");
		printf("You must use GNU compiler built for sun4c systems\n");
		return (EINVAL);
	}
#endif
#ifdef sun4m
	if (sizeof(struct pcb) == 0x364) {
		printf("skip: error - sun4c <machine/pcb.h> has been "
			"used for this build\n");
		printf("You must use GNU compiler built for sun4m systems\n");
		return (EINVAL);
	}
#endif

		

	switch (function_code) {

		case VDLOAD:
			rc = skip_init();
			if (rc != 0) {
				return (rc);
			}
			vdp->vdd_vdtab = (struct vdlinkage *)&vd;
			printf("skip: driver loaded\n");
			return (0);

		case VDUNLOAD:
			rc = skip_uninit();
			if (rc == 0) {
				printf("skip: driver unloaded\n");
			}
			return (rc);

		case VDSTAT:
			return (0);

		default:
			printf("skip: bad function_code %x in xxxinit()\n",
							function_code);
			return (EIO);
	}
}
