/*
 * Copyright (c) 1997-1999  The Stanford SRP Authentication Project
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * In addition, the following conditions apply:
 *
 * 1. Any software that incorporates the SRP authentication technology
 *    must display the following acknowlegment:
 *    "This product uses the 'Secure Remote Password' cryptographic
 *     authentication system developed by Tom Wu (tjw@CS.Stanford.EDU)."
 *
 * 2. Any software that incorporates all or part of the SRP distribution
 *    itself must also display the following acknowledgment:
 *    "This product includes software developed by Tom Wu and Eugene
 *     Jhong for the SRP Distribution (http://srp.stanford.edu/srp/)."
 *
 * 3. Redistributions in source or binary form must retain an intact copy
 *    of this copyright notice and list of conditions.
 */

/*
 * cast.h
 * Author: Tom Wu
 *
 * Type and function declarations for CAST.
 */

#ifndef _CAST_H_
#define _CAST_H_

#if     !defined(P)
#ifdef  __STDC__
#define P(x)    x
#else
#define P(x)    ()
#endif
#endif

#ifndef LITTLE_ENDIAN
# ifndef BIG_ENDIAN
#  ifndef WORDS_BIGENDIAN
#   define LITTLE_ENDIAN 1
#  endif
# endif
#endif

typedef unsigned int uint32;	/* Must be 32 bits */
typedef uint32 * uint32p;
typedef unsigned char uint8;
typedef uint8 * uint8p;

typedef struct {
  struct CastSubkeyPair {
    uint32 Km;
    uint32 Kr;
  } K[16];
  int ksize;
} CastKeySched;

/*
 * cast*_key_sched(schedule, key)
 *
 * Initializes the CAST key schedule "schedule" according to the given key.
 * The different setup routines accept different length keys:
 *
 *   cast5_40_key_sched: 40-bit/5-byte (12 round) keys
 *   cast5_64_key_sched: 64-bit/8-byte (12 round) keys
 *   cast5_80_key_sched: 80-bit/10-byte (12 round) keys
 *   cast128_key_sched: 128-bit/16-byte (16 round) keys
 */

extern void cast5_40_key_sched P((CastKeySched *, uint8 *));
extern void cast5_64_key_sched P((CastKeySched *, uint8 *));
extern void cast5_80_key_sched P((CastKeySched *, uint8 *));
extern void  cast128_key_sched P((CastKeySched *, uint8 *));

/*
 * cast_ecb_encrypt(output, input, schedule, mode)
 * cast_ecb_crypt(data, schedule, mode)
 *
 * Encrypts the 64-bit "input" according to the CAST key schedule
 * "schedule" and places the result in "output".  If "mode" is 0,
 * cast_ecb_encrypt will encrypt, otherwise it will decrypt.
 * "Output" and "input" can point to the same memory, in which case
 * en/decryption will be performed in place.
 *
 * cast_ecb_crypt accepts input in the form of an array of two
 * 32-bit words and performs encryption/decryption in place.
 */

extern void cast_ecb_encrypt P((uint8 *, uint8 *, CastKeySched *, int));
extern void cast_ecb_crypt P((uint32 *, CastKeySched *, int));

#endif
