; -*- Scheme -*-
;
; $Id: char-set-07.scm,v 1.1 1998/03/16 07:57:47 foner Exp $

(require 'char-set:make)
(require 'char-set:insert!)

;+doc
; procedure: char-set:from-list
; arguments: char-list
; signature: list[char] -> char-set
;
; Create a new char-set which contains all the characters in CHAR-LIST
;-doc

(define char-set:from-list
  (lambda (cl)
    (let ((r (char-set:make)))
      (let loop ((l cl))
	(if (null? l)
	    r
	    (begin
	      (char-set:insert! r (car l))
	      (loop (cdr l))))))))

; eof
