; -*- Scheme -*-
;
; $Id: pathname16.scm,v 1.1 1998/03/16 07:59:12 foner Exp $

(require 'pathname::update)

;+doc
; procedure: pathname:+directory
; arguments: pathname directory
; signature: pathname pathname:directory -> pathname
; 
; Create new pathname consisting of PATHNAME with its directory overriden
; with DIRECTORY
;-doc

(define pathname:+directory
  (let ((id (lambda (x) x)))
    (lambda (pathname directory)
      (pathname::update pathname id id (lambda (_) directory) id id id))))

; eof
