; -*- Scheme -*-
;
; $Id: pathname18.scm,v 1.1 1998/03/16 07:59:13 foner Exp $

(require 'pathname:+directory)
(require 'substring->unix:pathname:directory)

;------------

;+doc
; procedure: unix:pathname:+directory-string
; arguments: pathname directory
; signature: pathname x string -> pathname
;
; Creates a new UNIX pathname consisting of PATHNAME with the directory
; overriden with DIRECTORY.
;-doc

(define unix:pathname:+directory-string
  (lambda (p d)
    (let ((cd (substring->unix:pathname:directory d 0 (string-length d))))
      (pathname:+directory p cd))))

; eof
