{============================================================================

  RIPEMD.PAS v2.2, Message Digest 5 Cipher Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl

    History: 1.0    Original release (14 Nov 94)
             2.0    ASM and PAS code rewritten entirely for OOP (Jan 95).
             2.1    RIPEMD object optimized for speed.
             2.1.2  Fixed bug in RIPEMD object Final routine.
             2.2.0  ASM code written to use MDContext record. OOP abandoned
                    for "compatability" with C implementations.

  Requires RIPEMD.ASM v2.2.0 or later (for 386 machines). Units may work
  for earlier versions of Turbo Pascal which support objects.

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
===========================================================================}
unit RIPEMD;

interface

type

  MDContext = record
      buf:  Array [0..15] of Byte; { RIPEMD Context  }
      bits: Array [0..7] of Byte;  { bit-count    }
      inb:  Array [0..63] of Byte; { input buffer }
    end;

procedure RIPEMDInit(var ctx: MDContext); far;
procedure RIPEMDUpdate(var ctx: MDContext; var buff; len: word); far;
procedure RIPEMDFinal(var digest; var ctx: MDContext); far;
procedure RIPEMDTransform(var inb, buf); far;

procedure RIPEMDFile(var f: file; var digest);  { Assumes file is open }
procedure RIPEMDBuff(var buff; len: word; var digest);

implementation

procedure RIPEMDInit(var ctx: MDContext); external; {$l RIPEMD}
procedure RIPEMDUpdate(var ctx: MDContext; var buff; len: word); external;
procedure RIPEMDFinal(var digest; var ctx: MDContext); external;
procedure RIPEMDTransform(var inb, buf); external;

procedure RIPEMDFile(var f: file; var digest); { RIPEMD of file }
var
  ctx: MDContext;
  i:   Word;
  inb: Array [0..4195] of Byte;
begin
  RIPEMDInit(ctx);
  repeat
    BlockRead(f,inb,SizeOf(inb),i);
    if i<>0 then RIPEMDUpdate(ctx,inb,i);
  until (i=0);
  RIPEMDFinal(digest,ctx);
end;

procedure RIPEMDBuff(var buff; len: word; var digest); { RIPEMD of buffer }
var
  ctx: MDContext;
begin
  RIPEMDInit(ctx);
  RIPEMDUpdate(ctx,buff,len);
  RIPEMDFinal(digest,ctx);
end;

end.



