/*
 * The author of this code is John Ioannidis, ji@tla.org,
 * 	(except when noted otherwise).
 *
 * This code was written in Athens, Greece, in November 1995.
 *
 * Copyright (C) 1995, by John Ioannidis.
 *	
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTY. IN PARTICULAR, THE AUTHOR DOES NOT MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * HISTORY
 *
 * $Log: ip_ah.h,v $
 * Revision 1.1  1995/11/29  14:33:45  ji
 * First release of the Encapsulation/IPSP code.
 *
 * Added IP encapsulation, AH and ESP processing, input and output modifications
 * to handle AF_ENCAP routes, and support for multiple SPIs.
 *
 *
 */

/*
 * Authentication Header Processing
 * Per RFC1826 (Atkinson, 1995)
 *
 */

struct ah
{
	u_char	ah_nh;			/* Next header (protocol) */
	u_char	ah_hl;			/* AH length, in 32-bit words */
	u_short	ah_rv;			/* reserved, must be 0 */
	u_long	ah_spi;			/* Security Parameters Index */
	u_char	ah_data[1];		/* More, really*/
};

#define AH_FLENGTH	8		/* size of fixed part */

struct ahstat
{
	u_long	ahs_hdrops;		/* packet shorter than header shows */
	u_long	ahs_notdb;
	u_long	ahs_badkcr;
	u_long	ahs_badauth;
	u_long	ahs_noxform;
	u_long	ahs_qfull;
};

#ifdef KERNEL
struct ahstat ahstat;
#endif

