%{
#include <linux/types.h>
#include <linux/ipsec.h>
#include <netinet/in.h>
#include "y.tab.h"
#include <ctype.h>
#include <string.h>

extern YYSTYPE yylval;

extern unsigned long long kconvert(char *);
extern unsigned long long mconvert(char *);
extern unsigned long long gconvert(char *);
extern unsigned long long iconvert(char *);
extern unsigned long long hexconvert(char *);
extern void hexconvertk(char *str, unsigned char km[256]);
%}

%%
acquire					return ACQUIRE;
add					return ADD;
ah					return AH;
ahkey					return AKEY;
all					return UNSPEC;
attach					return ATTACH;
bundle					return BUNDLE;
bytes					return BYTES;
clear_df				return CLEAR;
copy_df					return COPY;
create					return CREATEDEV;
dead					return DEAD;
delete					return DELETE;
des-cbc					return DESCBC;
des3-cbc				return DES3CBC;
des-iv32				return DESIV32;
des-iv64				return DESIV64;
dest					return DEST;
destroy					return DESTROYDEV;
detach					return DETACH;
dport					return DPORT;
dump					return DUMP;
dying					return DYING;
esp					return ESP;
espkey					return EKEY;
flags					return FLAGS;
flush					return FLUSH;
get					return GET;
getspi					return GETSPI;
hard					return HARD;
idea					return IDEA;
input					return INPUT;
larval					return LARVAL;
mature					return MATURE;
md5-hmac				return MD5HMAC;
md5-kpdk				return MD5KPDK;
none					return NONE;
output					return OUTPUT;
packets					return PACKETS;
policy					return POLICY;
position				return POSITION;
protocol				return PROTOCOL;
proxy					return PROXY;
quit					return QUIT;
register				return REGISTER;
replay					return REPLAY;
sha1					return SHA1;
soft					return SOFT;
source					return SOURCE;
spi					return SPI;
spiany					return SPIANY;
spirange				return SPIRANGE;
sport					return SPORT;
time					return TIME;
unspec					return UNSPEC;
update					return UPDATE;
use					return USE;
0x[0-9a-fA-F][0-9a-fA-F]*		{ yylval.lval = hexconvert(yytext); return INT; }
0X[0-9a-fA-F][0-9a-fA-F]*		{ hexconvertk(yytext, yylval.kval); return KEYMAT; }
[1-9][0-9]*K				{ yylval.lval = kconvert(yytext); return INT; }
[1-9][0-9]*M				{ yylval.lval = mconvert(yytext); return INT; }
[1-9][0-9]*G				{ yylval.lval = gconvert(yytext); return INT; }
[1-9][0-9]*				{ yylval.lval = iconvert(yytext); return INT; }
\.					return DOT;
\/					return SLASH;
;					return SEMI;
#.*\n					;
[a-zA-Z][a-zA-Z0-9:_]*			{ strncpy(yylval.str, yytext, 256);
					  return ID; }
[ \t\n]+				;
.					return ERROR;
%%

unsigned long long kconvert(char *str)
{
    unsigned long long val;
    char *end;

    val = strtouq(str, &end, 10);
    val *= 1024;
    return val;
}

unsigned long long mconvert(char *str)
{
    unsigned long long val;
    char *end;

    val = strtouq(str, &end, 10);
    val *= 1024*1024;
    return val;
}

unsigned long long gconvert(char *str)
{
    unsigned long long val;
    char *end;

    val = strtouq(str, &end, 10);
    val *= 1024*1024*1024;
    return val;
}

unsigned long long iconvert(char *str)
{
    unsigned long long val;
    char *end;

    val = strtouq(str, &end, 10);
    return val;
}

unsigned long long hexconvert(char *str)
{
    unsigned long long val;
    char *end;

    val = strtouq(str, &end, 16);
    return val;
}

#define HEXDIG(c)	((c >= '0' && c <= '9')?(c-'0'):(tolower(c)-'a'+10))

void hexconvertk(char *str, unsigned char km[256])
{
    int i, len, p;

    str += 2;
    len = strlen(str);
    km[0] = (len+1)>>1;
    i = 1;
    p = 0;
    if (len & 1) {
	km[i++] = HEXDIG(str[p]);
	len -= 1;
	p += 1;
    }
    while (len) {
	km[i++] = HEXDIG(str[p]) * 16 + HEXDIG(str[p+1]);
	len -= 2;
	p += 2;
    }
}
