/* $Id: pk_access.h,v 1.1 1997/12/02 19:25:30 gordo Exp $ */
/*
 * Simple pf_key interface for use as a library.
 *
 * Copyright (C) 1997, Gordon Oliver
 *
 * No warranty whatsoever is offered for this software.
 *
 * Permission to use, modify, or do whatever you wish with
 * this software is hereby granted, so long as you do not
 * remove this copyright notice, and so long as you do not
 * hold me responsible for any damage that it might cause.
 * You must also add a notice that you changed this software.
 *
 * This is _not_ the GNU GPL. You can sell this if you so choose.
 * You do _not_ have to include source for this work or
 * derived works.
 *
 * I would appreciate credit in which you use this software or
 * the linux PF_KEY interface.
 */

#ifndef __PK_ACCESS_H__
#define __PK_ACCESS_H__

#include <linux/pfkeyv2.h>

struct pk_message
{
    int flags;
    int iov_size;
    int iov_len;
    struct iovec *iov;
    struct sadb_msg hdr;
    struct sadb_ext *n_ex[SADB_EXT_MAX+1];
    struct sadb_ext *x_ex[50];
    void *alloced;
};

extern struct pk_message *pkmsg_new(void);
extern struct sadb_ext *pkmsg_add(struct pk_message *pm, int type, int size);
extern int pkmsg_send(int s, struct pk_message *pm);
extern struct pk_message *pkmsg_receive(int s);
extern void pkmsg_free(struct pk_message *pm);
extern void pkmsg_print(struct pk_message *pm);

#endif /* __PK_ACCESS_H__ */
/* EOF $Id: pk_access.h,v 1.1 1997/12/02 19:25:30 gordo Exp $ */
