/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 *
 * Changes by Angelos D. Keromytis and Niels Provos
 * ported from OpenBSD 2.2 by Petr Novak, <pn@i.cz>
 *
 * Kernel interface modified from ENskip-0.67 by Robert Muchsel
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

/*
 * Initialization code, and /proc file system interface code.
 */

#include <linux/module.h>
#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <linux/firewall.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#include "ipsec_fw.h"

#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif

#ifdef CONFIG_IPSEC_ESP
#include "ipsec_esp.h"
#endif

#ifdef DEBUG_IPSEC_EROUTE
int debug_eroute = 0;
#endif

#ifdef DEBUG_IPSEC_SPI
int debug_spi = 0;
#endif

static int
ipsec_rt_get_info(char *buffer, char **start, off_t offset, int length, int dummy)
{
	int len=0;
	off_t pos=0;
	int size = 0;

	/*
	 * XXX - Needs work. What happens when we have more than 3K
	 * characters worth of e-routing info to report?
	 */
	

#ifdef DEBUG_IPSEC_RADIJ
	if (debug_radij & DB_RJ_DUMPTREES)
	  rj_dumptrees();			/* XXXXXXXXX */
#endif

#ifdef DEBUG_IPSEC_EROUTE
	if (debug_eroute & DB_ER_PROCFS)
	  printk("ipsec_rt_get_info: buffer=0x%x, *start=0x%x, offset=%d, length=%d\n", (u_int)buffer, (u_int)*start, (int)offset, length);
#endif

	size = ipsec_walk(buffer);

	len += size;
	pos += size;
	*start = buffer+len-(pos-offset);	/* Start of wanted data */
	len = pos-offset;			/* Start slop */

	return len;
}

static int
ipsec_spi_get_info(char *buffer, char **start, off_t offset, int length, int dummy)
{

	int len=0;
	off_t pos=0;
	int size=0, ds;
	int i;
	char *buf = buffer;
	struct tdb *tdbp;

	/*
	 * XXX - Needs work. What happens when we have more than 3K
	 * characters worth of spi info to report?
	 */

#ifdef DEBUG_IPSEC_SPI
	if (debug_spi & DB_SP_PROCFS)
	  printk("ipsec_spi_get_info: buffer=0x%x, *start=0x%x, offset=%d, length=%d\n", (u_int)buffer, (u_int)*start, (int)offset, length);
#endif

	for (i = 0; i < TDB_HASHMOD; i++)
		for (tdbp = tdbh[i]; tdbp; tdbp = tdbp->tdb_hnext)
		{
			ds = sprintf(buf, "(%d.%d.%d.%d, %08x: ", 
					O4(tdbp->tdb_dst.s_addr),
					O3(tdbp->tdb_dst.s_addr),
					O2(tdbp->tdb_dst.s_addr),
					O1(tdbp->tdb_dst.s_addr),
					(u_int)ntohl(tdbp->tdb_spi));
			buf += ds; size += ds;
			if (tdbp->tdb_xform)
			{
				ds = sprintf(buf, "%d ", tdbp->tdb_xform->xf_type);
				buf += ds; size += ds;
				ds = tdbp->tdb_xform->xf_print(tdbp->tdb_xdata, buf);
				buf += ds; size += ds;
				if (tdbp->tdb_flags & TDBF_TUNNELING)
				{
					ds = sprintf(buf, " tunnel %d.%d.%d.%d->%d.%d.%d.%d",
						O4(tdbp->tdb_osrc.s_addr), 
						O3(tdbp->tdb_osrc.s_addr), 
						O2(tdbp->tdb_osrc.s_addr), 
						O1(tdbp->tdb_osrc.s_addr), 
						O4(tdbp->tdb_odst.s_addr), 
						O3(tdbp->tdb_odst.s_addr), 
						O2(tdbp->tdb_odst.s_addr), 
						O1(tdbp->tdb_odst.s_addr));
					buf += ds; size += ds;
				}
			} else {
				ds = sprintf(buf, "[no xform set]");
				buf += ds; size += ds;
			}
			ds = sprintf(buf, ")\n");
			buf += ds; size += ds;
		}
	
	len += size;
	pos += size;
	*start = buffer+len-(pos-offset);	/* Start of wanted data */
	len = pos-offset;			/* Start slop */

	return len;

}

static struct proc_dir_entry ipsec_rt =
{
	4242, 11, "ipsec-route",
	S_IFREG | 0444, 1, 0, 0, 0,
	&proc_net_inode_operations,
	ipsec_rt_get_info,
	NULL, NULL, NULL, NULL, NULL
};

static struct proc_dir_entry ipsec_spi =
{
	4243, 9, "ipsec-spi",
	S_IFREG | 0444, 1, 0, 0, 0,
	&proc_net_inode_operations,
	ipsec_spi_get_info,
	NULL, NULL, NULL, NULL, NULL
};

#if 0
/* hook for incoming packets */
struct firewall_ops skip_in =
{
  NULL,
  packet_accept,
  input_packet,
  packet_accept,
  PF_INET,
  10 /* make sure filter is called before real firewalls */
};
#endif

/* hook for outgoing packets */
struct firewall_ops skip_out =
{
  NULL,
  forward_packet,
  packet_nop,
  output_packet,
  PF_IPSEC,
  2  /* allow other filters to hook before us */
};

int
ipsec_init(void)
{
	struct xformsw *xsp;

	proc_register(&proc_net, &ipsec_rt);
	proc_register(&proc_net, &ipsec_spi);
	
	(void)netlink_attach(NETLINK_IPSEC, ipsec_callback);

	ipsec_radijinit();

#ifdef CONFIG_IPSEC_AH
	inet_add_protocol(&ah_protocol);
#endif

#ifdef CONFIG_IPSEC_ESP
	inet_add_protocol(&esp_protocol);
#endif

	for (xsp = xformsw; xsp < xformswNXFORMSW; xsp++)
	{
		printk("ipsec_init: attaching <%s>\n", xsp->xf_name);
		(*(xsp->xf_attach))();
	}

#if 0
	if (register_firewall(PF_INET, &skip_in) ||
#else
        if (
#endif
	    register_firewall(PF_IPSEC, &skip_out)) {
		printk("Unable to register ipsec as packet filter!\n");
		return -EIO;
	}

	interface_init();

	printk(KERN_INFO "ipsec: module initialized.\n");
	return 0;
}	


void ipsec_cleanup(void)
{
        
	if (proc_unregister(&proc_net, 4243) != 0)
		printk("ipsec: cannot unregister /proc/net/ipsec-spi\n");
	if (proc_unregister(&proc_net, 4242) != 0)
		printk("ipsec: cannot unregister /proc/net/ipsec-route\n");
	
	netlink_detach(NETLINK_IPSEC);
	/* ipsec_radijcleanup(); */
#ifdef CONFIG_IPSEC_AH
	if ( inet_del_protocol(&ah_protocol) < 0 )
		printk(KERN_INFO "ah close: can't remove protocol\n");
#endif
#ifdef CONFIG_IPSEC_ESP
	if ( inet_del_protocol(&esp_protocol) < 0 )
		printk(KERN_INFO "esp close: can't remove protocol\n");
#endif

	interface_exit();

	unregister_firewall(PF_IPSEC, &skip_out);
#if 0
	unregister_firewall(PF_INET, &skip_in);
#endif

	printk(KERN_INFO "ipsec: module unloaded.\n");
}

#ifdef MODULE
int init_module(void)
{
	return ipsec_init();
}

int cleanup_module(void)
{
        ipsec_cleanup();
        return 0;
}
#endif
