/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "constants.h"

/*
 * This file implements all the kernel communicating routines.
 * XXX Eventually it should use PF_KEY or what kernel API is available
 * XXX but for now this will have to do.
 */

/*
 * Handle a kernel request. Supposedly, there's a message in
 * the kernelsock socket.
 */
void
kernel_handle(int kernelfd, int sock)
{
    u_char buffer[1024];
    int n;
    struct sockaddr_in sin;
    int goal;
    
    n = read(kernelfd, buffer, 1024);
    if (n == -1)
    {
	log(1, "read() failed in kernel_handle()", 0, 0, 0);
	return;
    }

#ifdef DEBUG
    log(0, "read %d bytes from \"kernel\" socket", n, 0, 0);
#endif

    bcopy(buffer, &sin, sizeof(sin));
    bcopy(buffer + sizeof(sin), &goal, sizeof(goal));
    
#ifdef DEBUG
    log(0, "initiating exchange with [%s], port %d, goal %d", 
	inet_ntoa(sin.sin_addr), ntohs(sin.sin_port), goal);
#endif

    ipsecdoi_initiate(sock, sin, goal, KEY_OAKLEY);
}
