/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "constants.h"

/*
 * This is a hack for initiating ISAKMP exchanges.
 * All it does is send a message to a port where the daemon listens.
 * The message is composed of a sockaddr_in and a bitmask of
 * goals for the SA (see constants.h).
 */
main(int argc, char **argv)
{
    struct sockaddr_in sin, *sin2;
    char buffer[1024];
    int sock, goal = 0, i;

    if (argc < 5)
    {
	fprintf(stderr, "Usage: %s <daemon port> <remote address> <remote port> [encrypt] [authenticate] [tunnel]\n", argv[0]);
	exit(-1);
    }

    bzero(buffer, 1024);
    bzero(&sin, sizeof(sin));

    sock = socket(PF_INET, SOCK_DGRAM, 0);
    if (sock == -1)
    {
	perror("socket() failed");
	exit(-1);
    }
    
    sin.sin_family = AF_INET;
    sin.sin_port = htons(atoi(argv[1]));
    sin.sin_addr.s_addr = htonl(INADDR_LOOPBACK);

    sin2 = (struct sockaddr_in *) buffer;
    
    sin2->sin_family = AF_INET;
    sin2->sin_port = htons(atoi(argv[3]));
    sin2->sin_addr.s_addr = inet_addr(argv[2]);

#ifdef DEBUG
    fprintf(stdout, "Initiating with %s, port %d\n", 
	    inet_ntoa(sin2->sin_addr), atoi(argv[3]));
#endif

    for (i = 4; i < argc; i++)
      if (!strcmp(argv[i], "encrypt"))
	goal |= GOAL_ENCRYPT;
      else
	if (!strcmp(argv[i], "authenticate"))
	  goal |= GOAL_AUTHENTICATE;
	else
	  if (!strcmp(argv[i], "tunnel"))
	    goal |= GOAL_TUNNEL;
	  else
	  {
	      fprintf(stderr, "Unknown goal [%s]\n", argv[i]);
	      exit(-1);
	  }

    bcopy(&goal, buffer + sizeof(sin), sizeof(goal));

#ifdef DEBUG
    fprintf(stdout, "Goal = %d\n", goal);
#endif

    if (sendto(sock, buffer, sizeof(*sin2) + sizeof(goal),
	       0, (struct sockaddr *)&sin, sizeof(sin)) == -1)
    {
	perror("sendto() failed");
	exit(-1);
    }
    
#ifdef DEBUG
    fprintf(stdout, "Done.\n");
#endif

    exit(0);
}

