/* DES test vectors, derived from "Validating the Correctness of Hardware
   Implementations of the NBS Data Encryption Standard", NBS Special
   Publication 500-20, 1980 */

/* The data structure for the ( key, plaintext, ciphertext ) triplets.  Each
   set of tests also includes a string describing the test, suitable for
   printing as "Testing <description string>" during the testing process */

typedef struct {
	BYTE key[ DES_BLOCKSIZE ];
	BYTE plaintext[ DES_BLOCKSIZE ];
	BYTE ciphertext[ DES_BLOCKSIZE ];
	} DES_TEST;

/* Initial Permutation and Expansion test: Encrypt */

static char *testIPname = "Initial Permutation and Expansion";

static DES_TEST testIP[] = {
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x95, 0xF8, 0xA5, 0xE5, 0xDD, 0x31, 0xD9, 0x00 },
	  { 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xDD, 0x7F, 0x12, 0x1C, 0xA5, 0x01, 0x56, 0x19 },
	  { 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x2E, 0x86, 0x53, 0x10, 0x4F, 0x38, 0x34, 0xEA },
	  { 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x4B, 0xD3, 0x88, 0xFF, 0x6C, 0xD8, 0x1D, 0x4F },
	  { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x20, 0xB9, 0xE7, 0x67, 0xB2, 0xFB, 0x14, 0x56 },
	  { 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x55, 0x57, 0x93, 0x80, 0xD7, 0x71, 0x38, 0xEF },
	  { 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x6C, 0xC5, 0xDE, 0xFA, 0xAF, 0x04, 0x51, 0x2F },
	  { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x0D, 0x9F, 0x27, 0x9B, 0xA5, 0xD8, 0x72, 0x60 },
	  { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xD9, 0x03, 0x1B, 0x02, 0x71, 0xBD, 0x5A, 0x0A },
	  { 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x42, 0x42, 0x50, 0xB3, 0x7C, 0x3D, 0xD9, 0x51 },
	  { 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xB8, 0x06, 0x1B, 0x7E, 0xCD, 0x9A, 0x21, 0xE5 },
	  { 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xF1, 0x5D, 0x0F, 0x28, 0x6B, 0x65, 0xBD, 0x28 },
	  { 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xAD, 0xD0, 0xCC, 0x8D, 0x6E, 0x5D, 0xEB, 0xA1 },  
	  { 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xE6, 0xD5, 0xF8, 0x27, 0x52, 0xAD, 0x63, 0xD1 },  
	  { 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xEC, 0xBF, 0xE3, 0xBD, 0x3F, 0x59, 0x1A, 0x5E },
	  { 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xF3, 0x56, 0x83, 0x43, 0x79, 0xD1, 0x65, 0xCD },  
	  { 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x2B, 0x9F, 0x98, 0x2F, 0x20, 0x03, 0x7F, 0xA9 },
	  { 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x88, 0x9D, 0xE0, 0x68, 0xA1, 0x6F, 0x0B, 0xE6 },  
	  { 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xE1, 0x9E, 0x27, 0x5D, 0x84, 0x6A, 0x12, 0x98 },  
	  { 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x32, 0x9A, 0x8E, 0xD5, 0x23, 0xD7, 0x1A, 0xEC },
	  { 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xE7, 0xFC, 0xE2, 0x25, 0x57, 0xD2, 0x3C, 0x97 },  
	  { 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x12, 0xA9, 0xF5, 0x81, 0x7F, 0xF2, 0xD6, 0x5D },  
	  { 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xA4, 0x84, 0xC3, 0xAD, 0x38, 0xDC, 0x9C, 0x19 },
	  { 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xFB, 0xE0, 0x0A, 0x8A, 0x1E, 0xF8, 0xAD, 0x72 },  
	  { 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x75, 0x0D, 0x07, 0x94, 0x07, 0x52, 0x13, 0x63 },  
	  { 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x64, 0xFE, 0xED, 0x9C, 0x72, 0x4C, 0x2F, 0xAF },  
	  { 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xF0, 0x2B, 0x26, 0x3B, 0x32, 0x8E, 0x2B, 0x60 },  
	  { 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x9D, 0x64, 0x55, 0x5A, 0x9A, 0x10, 0xB8, 0x52 },
	  { 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xD1, 0x06, 0xFF, 0x0B, 0xED, 0x52, 0x55, 0xD7 },
	  { 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xE1, 0x65, 0x2C, 0x6B, 0x13, 0x8C, 0x64, 0xA5 },  
	  { 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xE4, 0x28, 0x58, 0x11, 0x86, 0xEC, 0x8F, 0x46 },  
	  { 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xAE, 0xB5, 0xF5, 0xED, 0xE2, 0x2D, 0x1A, 0x36 },
	  { 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xE9, 0x43, 0xD7, 0x56, 0x8A, 0xEC, 0x0C, 0x5C },  
	  { 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xDF, 0x98, 0xC8, 0x27, 0x6F, 0x54, 0xB0, 0x4B },
	  { 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xB1, 0x60, 0xE4, 0x68, 0x0F, 0x6C, 0x69, 0x6F },  
	  { 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xFA, 0x07, 0x52, 0xB0, 0x7D, 0x9C, 0x4A, 0xB8 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xCA, 0x3A, 0x2B, 0x03, 0x6D, 0xBC, 0x85, 0x02 },
	  { 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x5E, 0x09, 0x05, 0x51, 0x7B, 0xB5, 0x9B, 0xCF },  
	  { 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x81, 0x4E, 0xEB, 0x3B, 0x91, 0xD9, 0x07, 0x26 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x4D, 0x49, 0xDB, 0x15, 0x32, 0x91, 0x9C, 0x9F },
	  { 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x25, 0xEB, 0x5F, 0xC3, 0xF8, 0xCF, 0x06, 0x21 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xAB, 0x6A, 0x20, 0xC0, 0x62, 0x0D, 0x1C, 0x6F },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x79, 0xE9, 0x0D, 0xBC, 0x98, 0xF9, 0x2C, 0xCA },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x86, 0x6E, 0xCE, 0xDD, 0x80, 0x72, 0xBB, 0x0E },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x8B, 0x54, 0x53, 0x6F, 0x2F, 0x3E, 0x64, 0xA8 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xEA, 0x51, 0xD3, 0x97, 0x55, 0x95, 0xB8, 0x6B },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xCA, 0xFF, 0xC6, 0xAC, 0x45, 0x42, 0xDE, 0x31 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x8D, 0xD4, 0x5A, 0x2D, 0xDF, 0x90, 0x79, 0x6C },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x10, 0x29, 0xD5, 0x5E, 0x88, 0x0E, 0xC2, 0xD0 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x5D, 0x86, 0xCB, 0x23, 0x63, 0x9D, 0xBE, 0xA9 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x1D, 0x1C, 0xA8, 0x53, 0xAE, 0x7C, 0x0C, 0x5F },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xCE, 0x33, 0x23, 0x29, 0x24, 0x8F, 0x32, 0x28 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x84, 0x05, 0xD1, 0xAB, 0xE2, 0x4F, 0xB9, 0x42 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xE6, 0x43, 0xD7, 0x80, 0x90, 0xCA, 0x42, 0x07 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x48, 0x22, 0x1B, 0x99, 0x37, 0x74, 0x8A, 0x23 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xDD, 0x7C, 0x0B, 0xBD, 0x61, 0xFA, 0xFD, 0x54 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x2F, 0xBC, 0x29, 0x1A, 0x57, 0x0D, 0xB5, 0xC4 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xE0, 0x7C, 0x30, 0xD7, 0xE4, 0xE2, 0x6E, 0x12 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x09, 0x53, 0xE2, 0x25, 0x8E, 0x8E, 0x90, 0xA1 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x5B, 0x71, 0x1B, 0xC4, 0xCE, 0xEB, 0xF2, 0xEE },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xCC, 0x08, 0x3F, 0x1E, 0x6D, 0x9E, 0x85, 0xF6 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xD2, 0xFD, 0x88, 0x67, 0xD5, 0x0D, 0x2D, 0xFE },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x06, 0xE7, 0xEA, 0x22, 0xCE, 0x92, 0x70, 0x8F },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x16, 0x6B, 0x40, 0xB4, 0x4A, 0xBA, 0x4B, 0xD6 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 } }
	};

/* Inverse Permutation and Expansion test: Encrypt */

static char *testVPname = "Inverse Permutation and Expansion";

static DES_TEST testVP[] = {
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x95, 0xF8, 0xA5, 0xE5, 0xDD, 0x31, 0xD9, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xDD, 0x7F, 0x12, 0x1C, 0xA5, 0x01, 0x56, 0x19 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x2E, 0x86, 0x53, 0x10, 0x4F, 0x38, 0x34, 0xEA } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x4B, 0xD3, 0x88, 0xFF, 0x6C, 0xD8, 0x1D, 0x4F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x20, 0xB9, 0xE7, 0x67, 0xB2, 0xFB, 0x14, 0x56 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x55, 0x57, 0x93, 0x80, 0xD7, 0x71, 0x38, 0xEF } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x6C, 0xC5, 0xDE, 0xFA, 0xAF, 0x04, 0x51, 0x2F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x0D, 0x9F, 0x27, 0x9B, 0xA5, 0xD8, 0x72, 0x60 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xD9, 0x03, 0x1B, 0x02, 0x71, 0xBD, 0x5A, 0x0A } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x42, 0x42, 0x50, 0xB3, 0x7C, 0x3D, 0xD9, 0x51 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xB8, 0x06, 0x1B, 0x7E, 0xCD, 0x9A, 0x21, 0xE5 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xF1, 0x5D, 0x0F, 0x28, 0x6B, 0x65, 0xBD, 0x28 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xAD, 0xD0, 0xCC, 0x8D, 0x6E, 0x5D, 0xEB, 0xA1 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xE6, 0xD5, 0xF8, 0x27, 0x52, 0xAD, 0x63, 0xD1 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xEC, 0xBF, 0xE3, 0xBD, 0x3F, 0x59, 0x1A, 0x5E } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xF3, 0x56, 0x83, 0x43, 0x79, 0xD1, 0x65, 0xCD } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x2B, 0x9F, 0x98, 0x2F, 0x20, 0x03, 0x7F, 0xA9 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x88, 0x9D, 0xE0, 0x68, 0xA1, 0x6F, 0x0B, 0xE6 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xE1, 0x9E, 0x27, 0x5D, 0x84, 0x6A, 0x12, 0x98 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x32, 0x9A, 0x8E, 0xD5, 0x23, 0xD7, 0x1A, 0xEC } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xE7, 0xFC, 0xE2, 0x25, 0x57, 0xD2, 0x3C, 0x97 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x12, 0xA9, 0xF5, 0x81, 0x7F, 0xF2, 0xD6, 0x5D } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xA4, 0x84, 0xC3, 0xAD, 0x38, 0xDC, 0x9C, 0x19 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xFB, 0xE0, 0x0A, 0x8A, 0x1E, 0xF8, 0xAD, 0x72 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x75, 0x0D, 0x07, 0x94, 0x07, 0x52, 0x13, 0x63 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x64, 0xFE, 0xED, 0x9C, 0x72, 0x4C, 0x2F, 0xAF } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xF0, 0x2B, 0x26, 0x3B, 0x32, 0x8E, 0x2B, 0x60 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00 },
	  { 0x9D, 0x64, 0x55, 0x5A, 0x9A, 0x10, 0xB8, 0x52 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xD1, 0x06, 0xFF, 0x0B, 0xED, 0x52, 0x55, 0xD7 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xE1, 0x65, 0x2C, 0x6B, 0x13, 0x8C, 0x64, 0xA5 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xE4, 0x28, 0x58, 0x11, 0x86, 0xEC, 0x8F, 0x46 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xAE, 0xB5, 0xF5, 0xED, 0xE2, 0x2D, 0x1A, 0x36 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00 },  
	  { 0xE9, 0x43, 0xD7, 0x56, 0x8A, 0xEC, 0x0C, 0x5C } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00 },  
	  { 0xDF, 0x98, 0xC8, 0x27, 0x6F, 0x54, 0xB0, 0x4B } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00 },  
	  { 0xB1, 0x60, 0xE4, 0x68, 0x0F, 0x6C, 0x69, 0x6F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00 },  
	  { 0xFA, 0x07, 0x52, 0xB0, 0x7D, 0x9C, 0x4A, 0xB8 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },  
	  { 0xCA, 0x3A, 0x2B, 0x03, 0x6D, 0xBC, 0x85, 0x02 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00 },  
	  { 0x5E, 0x09, 0x05, 0x51, 0x7B, 0xB5, 0x9B, 0xCF } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00 },  
	  { 0x81, 0x4E, 0xEB, 0x3B, 0x91, 0xD9, 0x07, 0x26 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00 },
	  { 0x4D, 0x49, 0xDB, 0x15, 0x32, 0x91, 0x9C, 0x9F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00 },  
	  { 0x25, 0xEB, 0x5F, 0xC3, 0xF8, 0xCF, 0x06, 0x21 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00 },  
	  { 0xAB, 0x6A, 0x20, 0xC0, 0x62, 0x0D, 0x1C, 0x6F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00 },  
	  { 0x79, 0xE9, 0x0D, 0xBC, 0x98, 0xF9, 0x2C, 0xCA } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00 },  
	  { 0x86, 0x6E, 0xCE, 0xDD, 0x80, 0x72, 0xBB, 0x0E } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00 },
	  { 0x8B, 0x54, 0x53, 0x6F, 0x2F, 0x3E, 0x64, 0xA8 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00 },  
	  { 0xEA, 0x51, 0xD3, 0x97, 0x55, 0x95, 0xB8, 0x6B } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00 },  
	  { 0xCA, 0xFF, 0xC6, 0xAC, 0x45, 0x42, 0xDE, 0x31 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00 },  
	  { 0x8D, 0xD4, 0x5A, 0x2D, 0xDF, 0x90, 0x79, 0x6C } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00 },  
	  { 0x10, 0x29, 0xD5, 0x5E, 0x88, 0x0E, 0xC2, 0xD0 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00 },  
	  { 0x5D, 0x86, 0xCB, 0x23, 0x63, 0x9D, 0xBE, 0xA9 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00 },  
	  { 0x1D, 0x1C, 0xA8, 0x53, 0xAE, 0x7C, 0x0C, 0x5F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00 },  
	  { 0xCE, 0x33, 0x23, 0x29, 0x24, 0x8F, 0x32, 0x28 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00 },  
	  { 0x84, 0x05, 0xD1, 0xAB, 0xE2, 0x4F, 0xB9, 0x42 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00 },  
	  { 0xE6, 0x43, 0xD7, 0x80, 0x90, 0xCA, 0x42, 0x07 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00 },  
	  { 0x48, 0x22, 0x1B, 0x99, 0x37, 0x74, 0x8A, 0x23 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00 },  
	  { 0xDD, 0x7C, 0x0B, 0xBD, 0x61, 0xFA, 0xFD, 0x54 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80 },
	  { 0x2F, 0xBC, 0x29, 0x1A, 0x57, 0x0D, 0xB5, 0xC4 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40 },  
	  { 0xE0, 0x7C, 0x30, 0xD7, 0xE4, 0xE2, 0x6E, 0x12 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20 },  
	  { 0x09, 0x53, 0xE2, 0x25, 0x8E, 0x8E, 0x90, 0xA1 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10 },  
	  { 0x5B, 0x71, 0x1B, 0xC4, 0xCE, 0xEB, 0xF2, 0xEE } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08 },  
	  { 0xCC, 0x08, 0x3F, 0x1E, 0x6D, 0x9E, 0x85, 0xF6 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04 },
	  { 0xD2, 0xFD, 0x88, 0x67, 0xD5, 0x0D, 0x2D, 0xFE } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02 },  
	  { 0x06, 0xE7, 0xEA, 0x22, 0xCE, 0x92, 0x70, 0x8F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 },  
	  { 0x16, 0x6B, 0x40, 0xB4, 0x4A, 0xBA, 0x4B, 0xD6 } }
	}; 

/* Key Permutation tests: Encrypt */

static char *testKPname = "Key Permutation";

static DES_TEST testKP[] = {
	{ { 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x95, 0xA8, 0xD7, 0x28, 0x13, 0xDA, 0xA9, 0x4D } },
	{ { 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x0E, 0xEC, 0x14, 0x87, 0xDD, 0x8C, 0x26, 0xD5 } },
	{ { 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x7A, 0xD1, 0x6F, 0xFB, 0x79, 0xC4, 0x59, 0x26 } },
	{ { 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xD3, 0x74, 0x62, 0x94, 0xCA, 0x6A, 0x6C, 0xF3 } },
	{ { 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x80, 0x9F, 0x5F, 0x87, 0x3C, 0x1F, 0xD7, 0x61 } },
	{ { 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xC0, 0x2F, 0xAF, 0xFE, 0xC9, 0x89, 0xD1, 0xFC } },
	{ { 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x46, 0x15, 0xAA, 0x1D, 0x33, 0xE7, 0x2F, 0x10 } },
	{ { 0x01, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x20, 0x55, 0x12, 0x33, 0x50, 0xC0, 0x08, 0x58 } },
	{ { 0x01, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xDF, 0x3B, 0x99, 0xD6, 0x57, 0x73, 0x97, 0xC8 } },
	{ { 0x01, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x31, 0xFE, 0x17, 0x36, 0x9B, 0x52, 0x88, 0xC9 } },
	{ { 0x01, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xDF, 0xDD, 0x3C, 0xC6, 0x4D, 0xAE, 0x16, 0x42 } },
	{ { 0x01, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x17, 0x8C, 0x83, 0xCE, 0x2B, 0x39, 0x9D, 0x94 } },
	{ { 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x50, 0xF6, 0x36, 0x32, 0x4A, 0x9B, 0x7F, 0x80 } },
	{ { 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xA8, 0x46, 0x8E, 0xE3, 0xBC, 0x18, 0xF0, 0x6D } },
	{ { 0x01, 0x01, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xA2, 0xDC, 0x9E, 0x92, 0xFD, 0x3C, 0xDE, 0x92 } },
	{ { 0x01, 0x01, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xCA, 0xC0, 0x9F, 0x79, 0x7D, 0x03, 0x12, 0x87 } },
	{ { 0x01, 0x01, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x90, 0xBA, 0x68, 0x0B, 0x22, 0xAE, 0xB5, 0x25 } },
	{ { 0x01, 0x01, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xCE, 0x7A, 0x24, 0xF3, 0x50, 0xE2, 0x80, 0xB6 } },
	{ { 0x01, 0x01, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x88, 0x2B, 0xFF, 0x0A, 0xA0, 0x1A, 0x0B, 0x87 } },
	{ { 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x25, 0x61, 0x02, 0x88, 0x92, 0x45, 0x11, 0xC2 } },
	{ { 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xC7, 0x15, 0x16, 0xC2, 0x9C, 0x75, 0xD1, 0x70 } },
	{ { 0x01, 0x01, 0x01, 0x80, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x51, 0x99, 0xC2, 0x9A, 0x52, 0xC9, 0xF0, 0x59 } },
	{ { 0x01, 0x01, 0x01, 0x40, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xC2, 0x2F, 0x0A, 0x29, 0x4A, 0x71, 0xF2, 0x9F } },
	{ { 0x01, 0x01, 0x01, 0x20, 0x01, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xEE, 0x37, 0x14, 0x83, 0x71, 0x4C, 0x02, 0xEA } },
	{ { 0x01, 0x01, 0x01, 0x10, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xA8, 0x1F, 0xBD, 0x44, 0x8F, 0x9E, 0x52, 0x2F } },
	{ { 0x01, 0x01, 0x01, 0x08, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x4F, 0x64, 0x4C, 0x92, 0xE1, 0x92, 0xDF, 0xED } },
	{ { 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x1A, 0xFA, 0x9A, 0x66, 0xA6, 0xDF, 0x92, 0xAE } },
	{ { 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xB3, 0xC1, 0xCC, 0x71, 0x5C, 0xB8, 0x79, 0xD8 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x80, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x19, 0xD0, 0x32, 0xE6, 0x4A, 0xB0, 0xBD, 0x8B } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x40, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x3C, 0xFA, 0xA7, 0xA7, 0xDC, 0x87, 0x20, 0xDC } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xB7, 0x26, 0x5F, 0x7F, 0x44, 0x7A, 0xC6, 0xF3 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x10, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x9D, 0xB7, 0x3B, 0x3C, 0x0D, 0x16, 0x3F, 0x54 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x08, 0x01, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x81, 0x81, 0xB6, 0x5B, 0xAB, 0xF4, 0xA9, 0x75 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x93, 0xC9, 0xB6, 0x40, 0x42, 0xEA, 0xA2, 0x40 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x55, 0x70, 0x53, 0x08, 0x29, 0x70, 0x55, 0x92 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x80, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x86, 0x38, 0x80, 0x9E, 0x87, 0x87, 0x87, 0xA0 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x41, 0xB9, 0xA7, 0x9A, 0xF7, 0x9A, 0xC2, 0x08 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x7A, 0x9B, 0xE4, 0x2F, 0x20, 0x09, 0xA8, 0x92 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x29, 0x03, 0x8D, 0x56, 0xBA, 0x6D, 0x27, 0x45 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x54, 0x95, 0xC6, 0xAB, 0xF1, 0xE5, 0xDF, 0x51 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xAE, 0x13, 0xDB, 0xD5, 0x61, 0x48, 0x89, 0x33 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x02, 0x4D, 0x1F, 0xFA, 0x89, 0x04, 0xE3, 0x89 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x80, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xD1, 0x39, 0x97, 0x12, 0xF9, 0x9B, 0xF0, 0x2E } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x14, 0xC1, 0xD7, 0xC1, 0xCF, 0xFE, 0xC7, 0x9E } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x1D, 0xE5, 0x27, 0x9D, 0xAE, 0x3B, 0xED, 0x6F } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xE9, 0x41, 0xA3, 0x3F, 0x85, 0x50, 0x13, 0x03 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xDA, 0x99, 0xDB, 0xBC, 0x9A, 0x03, 0xF3, 0x79 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xB7, 0xFC, 0x92, 0xF9, 0x1D, 0x8E, 0x92, 0xE9 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xAE, 0x8E, 0x5C, 0xAA, 0x3C, 0xA0, 0x4E, 0x85 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x80 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x9C, 0xC6, 0x2D, 0xF4, 0x3B, 0x6E, 0xED, 0x74 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xD8, 0x63, 0xDB, 0xB5, 0xC5, 0x9A, 0x91, 0xA0 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xA1, 0xAB, 0x21, 0x90, 0x54, 0x5B, 0x91, 0xD7 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x08, 0x75, 0x04, 0x1E, 0x64, 0xC5, 0x70, 0xF7 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x5A, 0x59, 0x45, 0x28, 0xBE, 0xBE, 0xF1, 0xCC } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xFC, 0xDB, 0x32, 0x91, 0xDE, 0x21, 0xF0, 0xC0 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x86, 0x9E, 0xFD, 0x7F, 0x9F, 0x26, 0x5A, 0x09 } }
	};

/* Test of right-shifts in Decryption: Decrypt */

static char *testRSname = "Right-shifts in Decryption";

static DES_TEST testRS[] = {
	{ { 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x95, 0xA8, 0xD7, 0x28, 0x13, 0xDA, 0xA9, 0x4D },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x0E, 0xEC, 0x14, 0x87, 0xDD, 0x8C, 0x26, 0xD5 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x7A, 0xD1, 0x6F, 0xFB, 0x79, 0xC4, 0x59, 0x26 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xD3, 0x74, 0x62, 0x94, 0xCA, 0x6A, 0x6C, 0xF3 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x80, 0x9F, 0x5F, 0x87, 0x3C, 0x1F, 0xD7, 0x61 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xC0, 0x2F, 0xAF, 0xFE, 0xC9, 0x89, 0xD1, 0xFC },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x46, 0x15, 0xAA, 0x1D, 0x33, 0xE7, 0x2F, 0x10 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x20, 0x55, 0x12, 0x33, 0x50, 0xC0, 0x08, 0x58 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xDF, 0x3B, 0x99, 0xD6, 0x57, 0x73, 0x97, 0xC8 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x31, 0xFE, 0x17, 0x36, 0x9B, 0x52, 0x88, 0xC9 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0xDF, 0xDD, 0x3C, 0xC6, 0x4D, 0xAE, 0x16, 0x42 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },
	  { 0x17, 0x8C, 0x83, 0xCE, 0x2B, 0x39, 0x9D, 0x94 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x50, 0xF6, 0x36, 0x32, 0x4A, 0x9B, 0x7F, 0x80 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xA8, 0x46, 0x8E, 0xE3, 0xBC, 0x18, 0xF0, 0x6D },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xA2, 0xDC, 0x9E, 0x92, 0xFD, 0x3C, 0xDE, 0x92 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xCA, 0xC0, 0x9F, 0x79, 0x7D, 0x03, 0x12, 0x87 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x90, 0xBA, 0x68, 0x0B, 0x22, 0xAE, 0xB5, 0x25 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xCE, 0x7A, 0x24, 0xF3, 0x50, 0xE2, 0x80, 0xB6 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x88, 0x2B, 0xFF, 0x0A, 0xA0, 0x1A, 0x0B, 0x87 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x25, 0x61, 0x02, 0x88, 0x92, 0x45, 0x11, 0xC2 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xC7, 0x15, 0x16, 0xC2, 0x9C, 0x75, 0xD1, 0x70 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x80, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x51, 0x99, 0xC2, 0x9A, 0x52, 0xC9, 0xF0, 0x59 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x40, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xC2, 0x2F, 0x0A, 0x29, 0x4A, 0x71, 0xF2, 0x9F },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x20, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xEE, 0x37, 0x14, 0x83, 0x71, 0x4C, 0x02, 0xEA },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x10, 0x01, 0x01, 0x01, 0x01 },  
	  { 0xA8, 0x1F, 0xBD, 0x44, 0x8F, 0x9E, 0x52, 0x2F },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x08, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x4F, 0x64, 0x4C, 0x92, 0xE1, 0x92, 0xDF, 0xED },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01 },  
	  { 0x1A, 0xFA, 0x9A, 0x66, 0xA6, 0xDF, 0x92, 0xAE },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01 },
	  { 0xB3, 0xC1, 0xCC, 0x71, 0x5C, 0xB8, 0x79, 0xD8 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x80, 0x01, 0x01, 0x01 },
	  { 0x19, 0xD0, 0x32, 0xE6, 0x4A, 0xB0, 0xBD, 0x8B },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x40, 0x01, 0x01, 0x01 },  
	  { 0x3C, 0xFA, 0xA7, 0xA7, 0xDC, 0x87, 0x20, 0xDC },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x01, 0x01 },  
	  { 0xB7, 0x26, 0x5F, 0x7F, 0x44, 0x7A, 0xC6, 0xF3 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x10, 0x01, 0x01, 0x01 },  
	  { 0x9D, 0xB7, 0x3B, 0x3C, 0x0D, 0x16, 0x3F, 0x54 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x08, 0x01, 0x01, 0x01 },  
	  { 0x81, 0x81, 0xB6, 0x5B, 0xAB, 0xF4, 0xA9, 0x75 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01 },  
	  { 0x93, 0xC9, 0xB6, 0x40, 0x42, 0xEA, 0xA2, 0x40 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01 },  
	  { 0x55, 0x70, 0x53, 0x08, 0x29, 0x70, 0x55, 0x92 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x80, 0x01, 0x01 },  
	  { 0x86, 0x38, 0x80, 0x9E, 0x87, 0x87, 0x87, 0xA0 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x01, 0x01 },  
	  { 0x41, 0xB9, 0xA7, 0x9A, 0xF7, 0x9A, 0xC2, 0x08 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x01 },  
	  { 0x7A, 0x9B, 0xE4, 0x2F, 0x20, 0x09, 0xA8, 0x92 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x01, 0x01 },  
	  { 0x29, 0x03, 0x8D, 0x56, 0xBA, 0x6D, 0x27, 0x45 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x01, 0x01 },  
	  { 0x54, 0x95, 0xC6, 0xAB, 0xF1, 0xE5, 0xDF, 0x51 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01 },  
	  { 0xAE, 0x13, 0xDB, 0xD5, 0x61, 0x48, 0x89, 0x33 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01 },  
	  { 0x02, 0x4D, 0x1F, 0xFA, 0x89, 0x04, 0xE3, 0x89 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x80, 0x01 },  
	  { 0xD1, 0x39, 0x97, 0x12, 0xF9, 0x9B, 0xF0, 0x2E },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x01 },  
	  { 0x14, 0xC1, 0xD7, 0xC1, 0xCF, 0xFE, 0xC7, 0x9E },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01 },
	  { 0x1D, 0xE5, 0x27, 0x9D, 0xAE, 0x3B, 0xED, 0x6F },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x01 },
	  { 0xE9, 0x41, 0xA3, 0x3F, 0x85, 0x50, 0x13, 0x03 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x01 },  
	  { 0xDA, 0x99, 0xDB, 0xBC, 0x9A, 0x03, 0xF3, 0x79 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01 },  
	  { 0xB7, 0xFC, 0x92, 0xF9, 0x1D, 0x8E, 0x92, 0xE9 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01 },  
	  { 0xAE, 0x8E, 0x5C, 0xAA, 0x3C, 0xA0, 0x4E, 0x85 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x80 },  
	  { 0x9C, 0xC6, 0x2D, 0xF4, 0x3B, 0x6E, 0xED, 0x74 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40 },  
	  { 0xD8, 0x63, 0xDB, 0xB5, 0xC5, 0x9A, 0x91, 0xA0 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20 },  
	  { 0xA1, 0xAB, 0x21, 0x90, 0x54, 0x5B, 0x91, 0xD7 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10 },  
	  { 0x08, 0x75, 0x04, 0x1E, 0x64, 0xC5, 0x70, 0xF7 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08 },  
	  { 0x5A, 0x59, 0x45, 0x28, 0xBE, 0xBE, 0xF1, 0xCC },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04 },  
	  { 0xFC, 0xDB, 0x32, 0x91, 0xDE, 0x21, 0xF0, 0xC0 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } },
	{ { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02 },  
	  { 0x86, 0x9E, 0xFD, 0x7F, 0x9F, 0x26, 0x5A, 0x09 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } }
	}; 

/* Data Permutation test: Encrypt */

static char *testDPname = "Data Permutation";

static DES_TEST testDP[] = {
	{ { 0x10, 0x46, 0x91, 0x34, 0x89, 0x98, 0x01, 0x31 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x88, 0xD5, 0x5E, 0x54, 0xF5, 0x4C, 0x97, 0xB4 } },
	{ { 0x10, 0x07, 0x10, 0x34, 0x89, 0x98, 0x80, 0x20 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x0C, 0x0C, 0xC0, 0x0C, 0x83, 0xEA, 0x48, 0xFD } },
	{ { 0x10, 0x07, 0x10, 0x34, 0xC8, 0x98, 0x01, 0x20 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x83, 0xBC, 0x8E, 0xF3, 0xA6, 0x57, 0x01, 0x83 } },
	{ { 0x10, 0x46, 0x10, 0x34, 0x89, 0x98, 0x80, 0x20 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xDF, 0x72, 0x5D, 0xCA, 0xD9, 0x4E, 0xA2, 0xE9 } },
	{ { 0x10, 0x86, 0x91, 0x15, 0x19, 0x19, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xE6, 0x52, 0xB5, 0x3B, 0x55, 0x0B, 0xE8, 0xB0 } },
	{ { 0x10, 0x86, 0x91, 0x15, 0x19, 0x58, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xAF, 0x52, 0x71, 0x20, 0xC4, 0x85, 0xCB, 0xB0 } },
	{ { 0x51, 0x07, 0xB0, 0x15, 0x19, 0x58, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x0F, 0x04, 0xCE, 0x39, 0x3D, 0xB9, 0x26, 0xD5 } },
	{ { 0x10, 0x07, 0xB0, 0x15, 0x19, 0x19, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xC9, 0xF0, 0x0F, 0xFC, 0x74, 0x07, 0x90, 0x67 } },
	{ { 0x31, 0x07, 0x91, 0x54, 0x98, 0x08, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x7C, 0xFD, 0x82, 0xA5, 0x93, 0x25, 0x2B, 0x4E } },
	{ { 0x31, 0x07, 0x91, 0x94, 0x98, 0x08, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xCB, 0x49, 0xA2, 0xF9, 0xE9, 0x13, 0x63, 0xE3 } },
	{ { 0x10, 0x07, 0x91, 0x15, 0xB9, 0x08, 0x01, 0x40 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x00, 0xB5, 0x88, 0xBE, 0x70, 0xD2, 0x3F, 0x56 } },
	{ { 0x31, 0x07, 0x91, 0x15, 0x98, 0x08, 0x01, 0x40 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x40, 0x6A, 0x9A, 0x6A, 0xB4, 0x33, 0x99, 0xAE } },
	{ { 0x10, 0x07, 0xD0, 0x15, 0x89, 0x98, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x6C, 0xB7, 0x73, 0x61, 0x1D, 0xCA, 0x9A, 0xDA } },
	{ { 0x91, 0x07, 0x91, 0x15, 0x89, 0x98, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x67, 0xFD, 0x21, 0xC1, 0x7D, 0xBB, 0x5D, 0x70 } },
	{ { 0x91, 0x07, 0xD0, 0x15, 0x89, 0x19, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x95, 0x92, 0xCB, 0x41, 0x10, 0x43, 0x07, 0x87 } },
	{ { 0x10, 0x07, 0xD0, 0x15, 0x98, 0x98, 0x01, 0x20 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xA6, 0xB7, 0xFF, 0x68, 0xA3, 0x18, 0xDD, 0xD3 } },
	{ { 0x10, 0x07, 0x94, 0x04, 0x98, 0x19, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x4D, 0x10, 0x21, 0x96, 0xC9, 0x14, 0xCA, 0x16 } },
	{ { 0x01, 0x07, 0x91, 0x04, 0x91, 0x19, 0x04, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x2D, 0xFA, 0x9F, 0x45, 0x73, 0x59, 0x49, 0x65 } },
	{ { 0x01, 0x07, 0x91, 0x04, 0x91, 0x19, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xB4, 0x66, 0x04, 0x81, 0x6C, 0x0E, 0x07, 0x74 } },
	{ { 0x01, 0x07, 0x94, 0x04, 0x91, 0x19, 0x04, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x6E, 0x7E, 0x62, 0x21, 0xA4, 0xF3, 0x4E, 0x87 } },
	{ { 0x19, 0x07, 0x92, 0x10, 0x98, 0x1A, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xAA, 0x85, 0xE7, 0x46, 0x43, 0x23, 0x31, 0x99 } },
	{ { 0x10, 0x07, 0x91, 0x19, 0x98, 0x19, 0x08, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x2E, 0x5A, 0x19, 0xDB, 0x4D, 0x19, 0x62, 0xD6 } },
	{ { 0x10, 0x07, 0x91, 0x19, 0x98, 0x1A, 0x08, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0x23, 0xA8, 0x66, 0xA8, 0x09, 0xD3, 0x08, 0x94 } },
	{ { 0x10, 0x07, 0x92, 0x10, 0x98, 0x19, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xD8, 0x12, 0xD9, 0x61, 0xF0, 0x17, 0xD3, 0x20 } },
	{ { 0x10, 0x07, 0x91, 0x15, 0x98, 0x19, 0x01, 0x0B },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x05, 0x56, 0x05, 0x81, 0x6E, 0x58, 0x60, 0x8F } },
	{ { 0x10, 0x04, 0x80, 0x15, 0x98, 0x19, 0x01, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	  { 0xAB, 0xD8, 0x8E, 0x8B, 0x1B, 0x77, 0x16, 0xF1 } },
	{ { 0x10, 0x04, 0x80, 0x15, 0x98, 0x19, 0x01, 0x02 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x53, 0x7A, 0xC9, 0x5B, 0xE6, 0x9D, 0xA1, 0xE1 } },
	{ { 0x10, 0x04, 0x80, 0x15, 0x98, 0x19, 0x01, 0x08 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xAE, 0xD0, 0xF6, 0xAE, 0x3C, 0x25, 0xCD, 0xD8 } },
	{ { 0x10, 0x02, 0x91, 0x14, 0x98, 0x10, 0x01, 0x04 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xB3, 0xE3, 0x5A, 0x5E, 0xE5, 0x3E, 0x7B, 0x8D } },
	{ { 0x10, 0x02, 0x91, 0x15, 0x98, 0x19, 0x01, 0x04 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x61, 0xC7, 0x9C, 0x71, 0x92, 0x1A, 0x2E, 0xF8 } },
	{ { 0x10, 0x02, 0x91, 0x15, 0x98, 0x10, 0x02, 0x01 },  
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0xE2, 0xF5, 0x72, 0x8F, 0x09, 0x95, 0x01, 0x3C } },
	{ { 0x10, 0x02, 0x91, 0x16, 0x98, 0x10, 0x01, 0x01 },
	  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  
	  { 0x1A, 0xEA, 0xC3, 0x9A, 0x61, 0xF0, 0xA4, 0x64 } }
	}; 

/* S-Box test: Encrypt */

static char *testSBname = "S-Boxes";

static DES_TEST testSB[] = {
	{ { 0x7C, 0xA1, 0x10, 0x45, 0x4A, 0x1A, 0x6E, 0x57 },
	  { 0x01, 0xA1, 0xD6, 0xD0, 0x39, 0x77, 0x67, 0x42 },
	  { 0x69, 0x0F, 0x5B, 0x0D, 0x9A, 0x26, 0x93, 0x9B } },
	{ { 0x01, 0x31, 0xD9, 0x61, 0x9D, 0xC1, 0x37, 0x6E },
	  { 0x5C, 0xD5, 0x4C, 0xA8, 0x3D, 0xEF, 0x57, 0xDA },
	  { 0x7A, 0x38, 0x9D, 0x10, 0x35, 0x4B, 0xD2, 0x71 } },
	{ { 0x07, 0xA1, 0x13, 0x3E, 0x4A, 0x0B, 0x26, 0x86 },  
	  { 0x02, 0x48, 0xD4, 0x38, 0x06, 0xF6, 0x71, 0x72 },
	  { 0x86, 0x8E, 0xBB, 0x51, 0xCA, 0xB4, 0x59, 0x9A } },
	{ { 0x38, 0x49, 0x67, 0x4C, 0x26, 0x02, 0x31, 0x9E },  
	  { 0x51, 0x45, 0x4B, 0x58, 0x2D, 0xDF, 0x44, 0x0A },  
	  { 0x71, 0x78, 0x87, 0x6E, 0x01, 0xF1, 0x9B, 0x2A } },
	{ { 0x04, 0xB9, 0x15, 0xBA, 0x43, 0xFE, 0xB5, 0xB6 },  
	  { 0x42, 0xFD, 0x44, 0x30, 0x59, 0x57, 0x7F, 0xA2 },  
	  { 0xAF, 0x37, 0xFB, 0x42, 0x1F, 0x8C, 0x40, 0x95 } },
	{ { 0x01, 0x13, 0xB9, 0x70, 0xFD, 0x34, 0xF2, 0xCE },  
	  { 0x05, 0x9B, 0x5E, 0x08, 0x51, 0xCF, 0x14, 0x3A },
	  { 0x86, 0xA5, 0x60, 0xF1, 0x0E, 0xC6, 0xD8, 0x5B } },
	{ { 0x01, 0x70, 0xF1, 0x75, 0x46, 0x8F, 0xB5, 0xE6 },
	  { 0x07, 0x56, 0xD8, 0xE0, 0x77, 0x47, 0x61, 0xD2 },  
	  { 0x0C, 0xD3, 0xDA, 0x02, 0x00, 0x21, 0xDC, 0x09 } },
	{ { 0x43, 0x29, 0x7F, 0xAD, 0x38, 0xE3, 0x73, 0xFE },
	  { 0x76, 0x25, 0x14, 0xB8, 0x29, 0xBF, 0x48, 0x6A },  
	  { 0xEA, 0x67, 0x6B, 0x2C, 0xB7, 0xDB, 0x2B, 0x7A } },
	{ { 0x07, 0xA7, 0x13, 0x70, 0x45, 0xDA, 0x2A, 0x16 },
	  { 0x3B, 0xDD, 0x11, 0x90, 0x49, 0x37, 0x28, 0x02 },  
	  { 0xDF, 0xD6, 0x4A, 0x81, 0x5C, 0xAF, 0x1A, 0x0F } },
	{ { 0x04, 0x68, 0x91, 0x04, 0xC2, 0xFD, 0x3B, 0x2F },  
	  { 0x26, 0x95, 0x5F, 0x68, 0x35, 0xAF, 0x60, 0x9A },  
	  { 0x5C, 0x51, 0x3C, 0x9C, 0x48, 0x86, 0xC0, 0x88 } },
	{ { 0x37, 0xD0, 0x6B, 0xB5, 0x16, 0xCB, 0x75, 0x46 },  
	  { 0x16, 0x4D, 0x5E, 0x40, 0x4F, 0x27, 0x52, 0x32 },  
	  { 0x0A, 0x2A, 0xEE, 0xAE, 0x3F, 0xF4, 0xAB, 0x77 } },
	{ { 0x1F, 0x08, 0x26, 0x0D, 0x1A, 0xC2, 0x46, 0x5E },
	  { 0x6B, 0x05, 0x6E, 0x18, 0x75, 0x9F, 0x5C, 0xCA },  
	  { 0xEF, 0x1B, 0xF0, 0x3E, 0x5D, 0xFA, 0x57, 0x5A } },
	{ { 0x58, 0x40, 0x23, 0x64, 0x1A, 0xBA, 0x61, 0x76 },  
	  { 0x00, 0x4B, 0xD6, 0xEF, 0x09, 0x17, 0x60, 0x62 },  
	  { 0x88, 0xBF, 0x0D, 0xB6, 0xD7, 0x0D, 0xEE, 0x56 } },
	{ { 0x02, 0x58, 0x16, 0x16, 0x46, 0x29, 0xB0, 0x07 },  
	  { 0x48, 0x0D, 0x39, 0x00, 0x6E, 0xE7, 0x62, 0xF2 },  
	  { 0xA1, 0xF9, 0x91, 0x55, 0x41, 0x02, 0x0B, 0x56 } },
	{ { 0x49, 0x79, 0x3E, 0xBC, 0x79, 0xB3, 0x25, 0x8F },  
	  { 0x43, 0x75, 0x40, 0xC8, 0x69, 0x8F, 0x3C, 0xFA },  
	  { 0x6F, 0xBF, 0x1C, 0xAF, 0xCF, 0xFD, 0x05, 0x56 } },
	{ { 0x4F, 0xB0, 0x5E, 0x15, 0x15, 0xAB, 0x73, 0xA7 },  
	  { 0x07, 0x2D, 0x43, 0xA0, 0x77, 0x07, 0x52, 0x92 },  
	  { 0x2F, 0x22, 0xE4, 0x9B, 0xAB, 0x7C, 0xA1, 0xAC } },
	{ { 0x49, 0xE9, 0x5D, 0x6D, 0x4C, 0xA2, 0x29, 0xBF },
	  { 0x02, 0xFE, 0x55, 0x77, 0x81, 0x17, 0xF1, 0x2A },
	  { 0x5A, 0x6B, 0x61, 0x2C, 0xC2, 0x6C, 0xCE, 0x4A } },
	{ { 0x01, 0x83, 0x10, 0xDC, 0x40, 0x9B, 0x26, 0xD6 },
	  { 0x1D, 0x9D, 0x5C, 0x50, 0x18, 0xF7, 0x28, 0xC2 },
	  { 0x5F, 0x4C, 0x03, 0x8E, 0xD1, 0x2B, 0x2E, 0x41 } },
	{ { 0x1C, 0x58, 0x7F, 0x1C, 0x13, 0x92, 0x4F, 0xEF },
	  { 0x30, 0x55, 0x32, 0x28, 0x6D, 0x6F, 0x29, 0x5A },
	  { 0x63, 0xFA, 0xC0, 0xD0, 0x34, 0xD9, 0xF7, 0x93 } }
	};
