/**
   SSLPRF.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Sun May  9 20:14:49 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: SSLPRF.java,v 1.3 1999/06/22 06:24:54 ekr Exp $

*/


package COM.claymoresystems.ptls;

abstract class SSLPRF {
     public static final int SSL_PRF_MASTER_SECRET = 1;
     public static final int SSL_PRF_KEY_BLOCK = 2;
     public static final int SSL_PRF_CLIENT_WRITE_KEY = 3;
     public static final int SSL_PRF_SERVER_WRITE_KEY = 4;
     public static final int SSL_PRF_CLIENT_WRITE_IV = 5;
     public static final int SSL_PRF_SERVER_WRITE_IV = 6;     

     public static SSLPRF getPRFInstance(int version){
       switch (version){
	 case SSLHandshake.SSL_V3_VERSION:
	   return new SSLv3PRF();
	 case SSLHandshake.TLS_V1_VERSION:
	   return new TLSPRF();
	 default:
	   throw new Error("Invalid SSL version");
       }
     }
     
     abstract void PRF(byte[] seed, int usage, byte[] client_random,
       byte[] server_random, byte[] out);
};


