/**
   SSLInputStream.c

   Copyright (C) 1999, RTFM, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Jun 10 07:17:04 1999
 */


static char *RCSSTRING="$Id: SSLInputStream.c,v 1.1.1.1 1999/06/17 18:49:02 ekr Exp $";

#include "COM_claymore_sslg_openssl_SSLSocket.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <openssl/ssl.h>
#include <native_common.h>

extern BIO *bio_err;

JNIEXPORT jint JNICALL Java_COM_claymore_sslg_openssl_SSLInputStream_nativeRead
  (JNIEnv *env, jobject thisObj, jobject sock, jbyteArray data, jint off, jint len)
  {
    c_SSLSocket *s;
    jbyte *buf;
    EXCEPT_DECL;
    int readb;
    
    if(!(s=get_context(env,sock)))
      return(0);

    if(!(buf=(jbyte *)malloc(len)))
      THROW("java/lang/InternalError","No more memory");

    readb=SSL_read(s->ssl, (char *)buf, len);

    switch(SSL_get_error(s->ssl,readb)){
      case SSL_ERROR_NONE:
	(*env)->SetByteArrayRegion(env,data,off,readb,buf);
	goto thrown;
      case SSL_ERROR_ZERO_RETURN:
	readb=-1;
	break;
      default:
	readb=-1;
	ERR_print_errors(bio_err);
	THROW("java/io/IOException","Some sort of problem");
    }

  thrown:
    free(buf);
    EXCEPT_HANDLE
    return(readb);
  }
      
      
    
    

    
