/**
   native_common.h

   Copyright (C) 1999, RTFM, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Wed Jun  9 14:37:55 1999
 */


#ifndef _native_common_h
#define _native_common_h

#include <openssl/ssl.h>

typedef struct c_SSLContext_ {
     SSL_CTX *ctx;
} c_SSLContext;

typedef struct c_SSLSocket_ {
     SSL *ssl;
     int sock;
} c_SSLSocket;
     
#define EXCEPT_DECL char *_exception=0, *_msg=0
#ifndef DEBUG
#define THROW(a,b) do { _exception=a; _msg=b; goto thrown; } while(0)
#else
#define THROW(a,b) do { _exception=a; _msg=b; \
fprintf(stderr,"Exception: %s at %s:%d\n",_msg,__FILE__,__LINE__);\
goto thrown;} while(0)
#endif
#define EXCEPT_HANDLE if(_exception) throw_exception(env,thisObj,_exception,_msg);

void *get_context(JNIEnv *env, jobject thisObj);
void throw_exception(JNIEnv *env,jobject thisObj,char *except_type,
  char *msg);

#endif

