//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : warning.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_WARNING_H
#define LIDIA_WARNING_H

typedef void (*warning_handler_ptr)(char *, char *);

extern warning_handler_ptr lidia_warning_handler;
extern void default_warning_handler(char *, char *);
extern warning_handler_ptr set_warning_handler(warning_handler_ptr);

#ifdef LIDIA_WARNINGS
#define warning_handler(name, message) lidia_warning_handler(name, message)
#else
#define warning_handler(name, message) { }
#endif

#endif
