#include <stdio.h>
#define CONFIG_FUNCTIONS
#include "sys-params.h"
#include "types.h"
#include "exceptions.h"

#define UNIMPLEMENTED(name) \
    fprintf(stderr, "Unimplemented: %s\n", name); fflush(stderr);  abort();

GetStackPointer() { UNIMPLEMENTED("GetStackPointer"); }

SetStackPointer() { UNIMPLEMENTED("SetStackPointer"); }

struct Module *
LoadModule(struct Module *module, FILE *bfile)
{ UNIMPLEMENTED("LoadModule"); }

HandleAuxFile(struct Module *module, char *auxFileName)
{ UNIMPLEMENTED("HandleAuxFile"); }

DoRelocations()
{ UNIMPLEMENTED("DoRelocations"); }

long TmpSaveRegs[2];
/* DummyFrame has a pseudo-RL that can be safely stored into
 * when various routines patch FRAME_RL(_Handler_->patched_FP) */
char DummyFrame[8] = {0};
Continuation NullHandler[1] =
    {NULL, 0, {0}, DummyFrame};
Continuation InteractiveHandler[1] =
    {NULL, 0, {0}, DummyFrame};
struct { long RL; long FP; } Patched = { 0, (long)DummyFrame };
#define Patched_RL "_Patched+0"
#define Patched_FP "_Patched+4"

Patch_Return() { UNIMPLEMENTED("Patch_Return"); }

SaveOrHandler()
{
    UNIMPLEMENTED("SaveOrHandler");
}

CreateContinuation()
{
    UNIMPLEMENTED("CreateContinuation");
}

SaveIfHandler(void* addr, Continuation* cont)
{
    cont->kind = 1;
    cont->undo_trail = UndoTrail;

    /* Link it in. */
    cont->prev = &_Handler_;
    cont->next = _Handler_;
    _Handler_->prev = &cont->next;
    _Handler_ = cont;

#if 0
    if (setjmp(cont->jump_buf)) {
	/* Here on raise */
	return 0;
    }
#endif
    return 1;
}

InvokeContinuation(Continuation *cont, void *result /*IGNORED*/)
{
    char *new_SP = CONT_SAVE_SP(_Handler_);
    if (cont->kind == 0) BadContinuation();
    _InvokeContinuation(new_SP, cont);
}

_InvokeContinuation(void *new_sp, Continuation *cont)
{
    longjmp(cont->jump_buf, 1);
}

void * lookup_global_label(char *name, int *found)
{
  UNIMPLEMENTED("lookup_global_label");
}


/* MAGIC C++ STUFF */

int isA_Offset = 12; /* assumes isA is first method in VTable */
#if 0
int RecordVTableSize = -1;
extern struct Record EmptyRecord;
void FindRecordVTableSize()
{
    void *RecordVTable = *(void**)&EmptyRecord;
    RecordVTableSize = (((long*)RecordVTable)[1] + 1) * 8;
}
#endif

int GetVTableSize(void *vTable)
{
    return (((int*)vTable)[1] + 1) * 8;
}
