#ifndef RXREGEXH
#define RXREGEXH

/*	Copyright (C) 1992 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
/*  t. lord	Tue Nov 17 16:33:29 1992	*/



#include "rx.h"
#include "rxrun.h"
#include "regex.h"

typedef reg_syntax_t rx_syntax;

struct rx_buf
{
  struct rx rx;			/* See rx.h */
  rx_syntax syntax;		/* See regex.h for syntax bit definitions. */

  /* The most recent error encountered while building or matching
   * this pattern.
   */
  int error;

  unsigned no_sub : 1;		/* If set, don't  return register offsets. */
  unsigned not_bol : 1;		/* If set, the anchors ('^' and '$') don't */
  unsigned not_eol : 1;		/*     match at the ends of the string.  */  
  unsigned newline_anchor : 1;	/* If true, an anchor at a newline matches.  */
  
  /* If REGS_UNALLOCATED, allocate space in the `regs' structure
   * for `max (RE_NREGS, re_nsub + 1)' groups.
   * If REGS_REALLOCATE, reallocate space if necessary.
   * If REGS_FIXED, use what's there.  */
#define REGS_UNALLOCATED 0
#define REGS_REALLOCATE 1
#define REGS_FIXED 2
  unsigned regs_allocated : 2;

  
  /* Either a translate table to apply to all characters before
   * comparing them, or zero for no translation.  The translation
   * is applied to a pattern when it is compiled and to a string
   * when it is matched.  */
  char * translate;

  void * buffer;		/* Malloced memory for the nfa. */
  unsigned long allocated;	/* Size of that memory. */

  /* Pointer to a fastmap, if any, otherwise zero.  re_search uses
   * the fastmap, if there is one, to skip over impossible
   * starting points for matches.  */
  char *fastmap;

  unsigned fastmap_accurate : 1; /* These three are internal. */
  unsigned can_match_empty : 1;  
  int regs_needed;		/* Regs needed to handle backrefs. */
  int start_id;			/* Id of the starting state. */
};


/* This is an array of error messages corresponding to the error codes
 * defined in regex.h.
 */
extern const char *rx_msg[];



#endif

