//
// prng.hxx
// 
// an abstract base class for pseudo-random number generators
//
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#ifndef _PRNG_HXX
#define _PRNG_HXX

#include <lmisc/ltypes.hxx>

class PRNG
{
protected:
  u8* _buffer;
  int _bufferSize;
  int _withdrawlPos;

  virtual void RefillBuffer()=0;
public:
  PRNG(const int bufferSize);
  virtual ~PRNG();

  virtual u8 NextByte();
  virtual u16 NextWord();
  virtual u32 NextDWord();

  virtual void NextQuantum(void* quantum, const int quantumSize);
};

#endif
