//
// sha1prng.hxx
// 
// A pseudo-random number generator based on the NIST/NSA's Secure
// Hash Algorithm and an algorithm in FIPS186
//
// implementation
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#ifndef _SHA1PRNG_HXX
#define _SHA1PRNG_HXX

#include <prng/prng.hxx>

class SHA1PRNG : public PRNG
{
private:
  const static u32 t[5];

  u32 _seed[16]; // actually seed with 352 0 bits appended
  u32 _compressedSeed[5];

  inline void AddMod160(const u32* x, const u32* y, u32* z);
  inline void IncMod160(u32* x);

  void RefillBuffer();
public:
  SHA1PRNG(const void* preSeed, const int preSeedSize);
  ~SHA1PRNG();
};

#include <prng/sha1prng.asm>

#endif 
