/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "new.h"
#include "msg.h"
#include "userlist.h"
#include "util.h"

extern FILE *yyin;

extern struct msg *msg;

static int fd_datain = 0;
static int fd_hdrout = 2;
static int fd_errout = 2;

static int fd_userout = -1;
static int fd_userne = -1;

static FILE *dataout = (FILE *)0;

struct bbuf *data_in()
{
    return(cbfdread(fd_datain));
}

static int data_out(buf)
struct bbuf *buf;
{
    return(cbfwrite(dataout, buf));
}

static int header_out(buf)
struct bbuf *buf;
{
    return(cbfdwrite(fd_hdrout, buf));
}

static int error_out(bbuf)
struct bbuf *bbuf;
{
    return(cbfdwrite(fd_errout, bbuf));
}

static int user_out(buf)
struct bbuf *buf;
{
    return(cbfdwrite(fd_userout, buf));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(fd_userne));
}


decrypt_main(argc, argv)
int argc;
char **argv;
{
    FILE *hdrs = (FILE *)0;
    FILE *dinfile = (FILE *)0;
    struct cbstruct iocbs;
    long opts = DECRYPT_NONE;
    struct user_list *tmplist = NULLUL;
    char **localopts = NULLVP;
    char **fileopt = NULLVP;
    char **showrecopt = NULLVP;
    char **showkeyopt = NULLVP;
    char **headeropt = NULLVP;
    char **myalias = NULLVP;
    char **me = NULLVP;
    int status = NOTOK;

    /*  initialize MOSS  */

    if (moss_init(argc, argv, &localopts) != OK) {
	(void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
	goto cleanup;
    }

    /* Process options */

    headeropt = tag_user(localopts, "header-in");

    if (headeropt == NULLVP || (argc == 2 && !strcasecmp(argv[1], "help"))) {
	(void) fprintf(stderr, "%s %s\n%s\n\n", PACKAGE, VERSION, COPYRIGHT);
    	(void) fprintf(stderr, "Usage: %s %s %s %s\n",
		       myname, "header-in <filename>",
		       "[ data-in <filename> ] [ data-out <filename> ]",
		       "[ show-recips no|yes ] [ show-key no|yes ]");
	goto cleanup;
    }

    showrecopt = tag_user(user_tailor, "show-recips");
    showkeyopt = tag_user(user_tailor, "show-key");

    if (!strcasecmp(*(showrecopt+1), "yes"))
	opts |= DECRYPT_SHOWRECIPS;
    if (!strcasecmp(*(showkeyopt+1), "yes"))
	    opts |= DECRYPT_SHOWKEY;

    myalias = tag_user(user_tailor, "my-alias");
    if (myalias == NULLVP) {
        (void) fprintf(stderr, "%s: missing my-alias\n", myname);
        goto cleanup;
    }

    if ((hdrs = fopen(*(headeropt+1), "r")) == (FILE *)0) {
	(void) fprintf(stderr, "%s: unable to read header-in file %s\n", 
		       myname, *(headeropt+1));
	goto cleanup;
    }

    if ((fileopt = tag_user(localopts, "data-in")) != NULLVP) 
        if ((dinfile = fopen(*(fileopt+1), "r")) != (FILE *)0) 
            fd_datain = fileno(dinfile);
        else {
            fprintf(stderr, "%s: unable to open data-in file %s\n",
                    myname, *(fileopt+1));
            goto cleanup;
        }

    if ((fileopt = tag_user(localopts, "data-out")) == NULLVP) 
	dataout = stdout;
    else
        if ((dataout = fopen(*(fileopt+1), "w")) == (FILE *)0) {
            fprintf(stderr, "%s: unable to open data-out file %s\n",
                    myname, *(fileopt+1));
            goto cleanup;
        }

    msg = alloc_msg();
    yyin = hdrs;

    if (yyparse()) {
	(void) fprintf(stderr,
		"%s: parse error, improperly formatted headers\n", myname);
	goto cleanup;
    }

    /* get my user record(s) so we can find my enciphered DEK */

    rewind_indexfile();
    while ((me = get_tv_user("alias", *(myalias+1))) != NULLVP) {
        tmplist = alloc_ul();
	tmplist->user = me;
	tmplist->next = msg->origusers;
	msg->origusers = tmplist;
	me = NULLVP;
	tmplist = NULLUL;
    }
    if (msg->origusers == NULLUL) {
	(void) fprintf(stderr, "%s: missing user for tag my-alias value %s\n",
		       *argv, *(myalias+1));
	goto cleanup;
    }

    BZERO(&iocbs, sizeof(struct cbstruct));
    iocbs.in_data = data_in;
    iocbs.out_data = data_out;
    iocbs.out_hdrs = header_out;
    iocbs.out_errs = error_out;

    if (dataout != stdout && dinfile != (FILE *)0) {
	fd_userout = 1;
	fd_userne = 0;
	iocbs.out_user = user_out;
	iocbs.ne_user = user_ne;
    }

    if (moss_decrypt(msg, opts, &iocbs) != OK) {
	(void) fprintf(stderr, "\n%s: unable to decrypt message\n", myname);
	goto cleanup;
    }

    (void) fprintf(stderr, "\nMessage has been decrypted.\n");
    status = OK;

 cleanup:

    FREE_MSG(msg);

    if (hdrs != (FILE *)0)
	(void) fclose(hdrs);
    if (dinfile != (FILE *)0)
	(void) fclose(dinfile);
    if (dataout != stdout)
	(void) fclose(dataout);

    return(status);
}
