/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_prts(eprts, dprts, rlength)
struct bbuf *eprts;
char **dprts;
int *rlength;
{
    struct bbuf *bb = NULLBB;
    int i, r;
	
    if (eprts == NULLBB || dprts == NULLVP || rlength == (int *)0) 
	return(NOTOK);

    FREE(*dprts);

    if (eprts->length < 2) 
	return(ASN1_ERR01);

    r = decode_str(eprts, (CLASS_UNIV|FORM_PRIM|DEFN_PRTS), &bb, rlength);

    if (r != OK) 
	return(r);


    *dprts = alloc_char(bb->length+1);

    if (bb->length)
	BCOPY(bb->data, *dprts, bb->length);
    (*dprts)[bb->length] = NULLC;

    (void) free_bbuf(bb);

    for (i=0; i < strlen(*dprts); i++)
	if (!isprint((*dprts)[i])) {
	    FREE(*dprts);
	    return(NOTOK);
	}

    return(OK);
}

