/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include <stdio.h>
#include "config.h"
#include "general.h"
#include "asn1.h"

#define	YEAR(y)		((y) >= 100 ? (y) : (y) + 1900)
#define	UNYEAR(y)	((y) < 1900 || (y) > 1999 ? (y) : (y) - 1900)

char   *time2str (u, generalized)
UTC	u;
int	generalized;
{
    int    hours, mins, zone;
    char  *bp;
    static char buffer[BUFSIZ];

    if (u == NULLUTC)
	return NULLCP;

    bp = buffer;

    if (generalized)
	(void) sprintf (bp, "%04d", YEAR (u -> ut_year));
    else
	(void) sprintf (bp, "%02d", UNYEAR (u -> ut_year));
    bp += strlen (bp);

    (void) sprintf (bp, "%02d%02d%02d%02d", u -> ut_mon, u -> ut_mday,
		u -> ut_hour, u -> ut_min);
    bp += strlen (bp);

    if (u -> ut_flags & UT_SEC
	    || (generalized && (u -> ut_flags & UT_USEC))) {
	(void) sprintf (bp, "%02d", u -> ut_sec);
	bp += strlen (bp);
    }
    if (generalized && (u -> ut_flags & UT_USEC)) {
	(void) sprintf (bp, ".%06d", u -> ut_usec);
	bp += strlen (bp);
    }

    if (u -> ut_flags & UT_ZONE)
	if ((zone = u -> ut_zone) == 0)
	    *bp++ = 'Z';
	else {
	    if (zone < 0)
		mins = (-zone) % 60, hours = (-zone) / 60;
	    else
		mins = zone % 60, hours = zone / 60;
	    (void) sprintf (bp, "%c%02d%02d", zone < 0 ? '-' : '+',
		    hours, mins);
	    bp += strlen (bp);
	}

    *bp = NULLC;

    return buffer;
}
