/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "cert.h"
#include "util.h"

free_cert(cert)
struct certificate *cert;
{
    if (cert == NULL_CERT)
	return(OK);

    FREE_TOBESIGNED(cert -> tobesigned);
    FREE_ALGID(cert -> sig_alg);
    FREE_BBUF(cert -> sig);

    free((char *)cert);
    return(OK);
}

free_tobesigned_cert(t)
struct tobesigned *t;
{
    if (t == NULL_TOBESIGNED)
	return(OK);

    FREE_BBUF(t -> issuer);
    FREE_VALID(t -> valid);
    FREE_BBUF(t -> subject);
    FREE_BBUF(t -> public);

    free((char *)t);
    return(OK);
}

free_valid_cert(v)
struct valid *v;
{
    if (v == NULL_VALID)
	return(OK);

    free((char *)v);
    return(OK);
}
