/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "cert.h"
#include "util.h"

version_cert(ecert, version, mode)
struct bbuf **ecert;
int *version;
int mode;
{
    struct certificate *cert= NULL_CERT;

    if (ecert == (struct bbuf **)0) {
        return(NOTOK);
    }
    if (version == (int *)0) {
	return(NOTOK);
    }
    if (decode_cert(*ecert, &cert) != OK) {
        return(NOTOK);
    }

    switch (mode) {
    case READ:
	if (cert -> tobesigned == (struct tobesigned *)0) {
	    return(NOTOK);
	}

	*version = cert -> tobesigned -> version;
	break;

    case WRITE:
	if (cert -> tobesigned == (struct tobesigned *)0) 
	    cert -> tobesigned = alloc_tobesigned_cert();

	cert -> tobesigned -> version = *version;
        if (encode_cert(cert, ecert) != OK) {
            return(NOTOK);
        }

	break;

    default:
	return(NOTOK);
    }

    return(OK);
}
