/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cert.h"
#include "crl.h"
#include "util.h"

check_crl(cert, crl)
struct bbuf *cert;
struct bbuf *crl;
{
    struct rcl_entry 	*ptr, *rcl= NULL_RCL_ENTRY;
    struct bbuf		*serial= NULLBB;
    int 		retval;

    if (cert == NULLBB) {
	retval = EINVAL;
	goto cleanup;
    }

    if (crl == NULLBB) {
	retval = EINVAL;
	goto cleanup;
    }

    if ((retval = serial_cert(&cert, &serial, READ)) != OK) 
        goto cleanup;

    if ((retval = rcl_crl(&crl, &rcl, READ)) != OK) 
        goto cleanup;

    for (ptr = rcl;
	 ptr != NULL_RCL_ENTRY && bbufcmp(ptr -> serial, serial) != 0;
	 ptr = ptr -> next)
	;

    if (ptr == NULL_RCL_ENTRY)
	retval = OK;
    else
	retval = BBADCRL;

 cleanup:
    FREE_RCL(rcl);
    FREE_BBUF(serial);

    return(retval);
}
