/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * decode_algid.c
 *---------------------------------------------------------------------------
 * ASN.1 decode algid structure as AlgorithmIdentifier SEQUENCE
 * (see encode_algid())
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "asn1.h"
#include "bbuf.h"
#include "crypto.h"
#include "oid.h"
#include "util.h"

int decode_algid(eaid, daid, rlength)
struct bbuf *eaid;
struct algid **daid;
int *rlength;
{
    int r;
    struct algent *ae;
    struct bbuf bb;
    int len, llen, pl;
    OID oid = NULLOID;
    
    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (eaid == NULLBB || daid == (struct algid **)0)
        return(NOTOK);

    FREE_ALGID(*daid);

    /* CHECK FOR TAG & LENGTH */
    if (eaid->length < 2) 
        return(ASN1_ERR01);

    /* CHECK FOR UNIVERSAL CONSTRUCTED SEQUENCE TAG */
    if (eaid->data[0] != (CLASS_UNIV|FORM_CONS|CONS_SEQ)) 
        return(ASN1_ERR02);

    /* DECODE THE LENGTH */
    if ((r = decode_len(&(eaid->data[1]), eaid->length-1, &len, &llen)) != OK)
        return(r);
    *rlength = 1 + llen + len;

    /* CHECK FOR NULL TYPE */
    if (!len)
	return(OK);

    /* ALLOCATE ALGID STRUCTURE */
    *daid = alloc_algid();

    /* DECODE THE OID */
    BZERO(&bb, sizeof(struct bbuf));
    bb.data = &(eaid->data[1+llen]);
    bb.length = len;
    if ((r = decode_oid(&bb, &oid, &pl)) != OK)
        goto cleanup;

    /* GET ALGORITHM ENTRY BY OID */
    if ((ae = getalgoid(algorithms, oid, ANY)) == NULL_ALGENT) {
        r = ASN1_ERR30;
        goto cleanup;
    }

    /* SET INTERNAL ALGORITHM CODE */
    (*daid)->alg = ae->code;

    /* IF NOT TYPE NULL, COPY ENCODED KEY PARAMETERS */
    bb.data = &(eaid->data[1+llen+pl]);
    bb.length = len - pl;
    if (bb.data[0] != (CLASS_UNIV|FORM_PRIM|PRIM_NULL) || bb.data[1] != 0x00) {
        if (((*daid)->parms = dup_bbuf(&bb)) == NULLBB) {
	    r = NOTOK;
	    goto cleanup;
        }
    }

    r = OK;

 cleanup:

    if (r != OK)
        FREE_ALGID(*daid);

    return(r);
}

