/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "dname.h"
#include "new.h"
#include "util.h"

moss_init(argc, argv, localopts)
int argc;
char **argv;
char ***localopts;
{
    char *cp;
    int ret = NOTOK;
    char **opts = NULLVP;

    /* check args */

    if (argc == 0 || argv == NULLVP || localopts == (char ***)0)
	goto cleanup;
    FREE_AV(*localopts);

    /* get the invocation name */

    if (myname == NULLCP)
	if ((cp = RINDEX(*argv, PATH_SEP)) == NULLCP)
	    myname = *argv;
	else
	    myname = ++cp;

    /* process tailor file */

    if ((ret = moss_tailor()) != OK)
	goto cleanup;

    /* update user_tailor with command line args and return local opts */
    
    opts = update_user(user_tailor, argv+1);
    
    /* set database */

    if ((ret = set_db()) != OK)
	goto cleanup;

    /* That's all */

    *localopts = opts;
    opts = NULLVP;
    ret = OK;

 cleanup:

    FREE_AV(opts);
    return ret;
}
