/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

unsigned char *code_table = (unsigned char *)
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

#define sextet_one(p)	((((p)[0]) >> 2) & 0x3f)
#define sextet_two(p)	(((((p)[0]) & 0x3) << 4) | ((((p)[1]) & 0xf0) >> 4))
#define sextet_three(p)	(((((p)[1]) & 0xf) << 2) | ((((p)[2]) >> 6) & 0x3))
#define sextet_four(p)	(((p)[2]) & 0x3f)
#define sextet_two_last(p)   ((((p)[0]) & 0x3) << 4)
#define sextet_three_last(p) ((((p)[1]) & 0xf) << 2)

bencode(bin,bout)
struct bbuf *bin;
struct bbuf **bout;
{
    int length, si, di; 

    /* DOUBLE-CHECK PARAMETERS */
    if (bin == NULLBB || bout == (struct bbuf **)0)
	return(NOTOK);

    FREE_BBUF(*bout);

    /* CHECK FOR ZERO LENGTH INPUT BUFFER */
    if (bin->length == 0)
	return(OK);

    /* ALLOCATE OUTPUT BUFFER OF APPROPRIATE LENGTH */
    *bout = alloc_bbuf();
    length = ((bin->length - 1) / 3 + 1) * 4;
    (*bout)->data = alloc_uchar(length+1); /* leave a NULLC */
    (*bout)->length = length;

    /* ENCODE ALL MULTIPLES OF 3 BYTES */
    for (di = si = 0; si< bin->length - 2; si+=3, di+=4) {
	(*bout)->data[di] = code_table[sextet_one(&(bin->data[si]))];
	(*bout)->data[di+1] = code_table[sextet_two(&(bin->data[si]))];
	(*bout)->data[di+2] = code_table[sextet_three(&(bin->data[si]))];
	(*bout)->data[di+3] = code_table[sextet_four(&(bin->data[si]))];
    }

    /* ENCODE LAST 1 or 2 BYTES */
    if (si < bin->length) {
	(*bout)->data[di] = code_table[sextet_one(&(bin->data[si]))];
	if (bin->length - si == 1) {
	   (*bout)->data[di+1]=code_table[sextet_two_last(&(bin->data[si]))];
	   (*bout)->data[di+2]='=';
	}
	else {
	   (*bout)->data[di+1]=code_table[sextet_two(&(bin->data[si]))];
	   (*bout)->data[di+2]=code_table[sextet_three_last(&(bin->data[si]))];
	}
	(*bout)->data[di+3]='=';
    }

   return(OK);
}
