/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "util.h"

char **fold(str, len, pre)
char *str;
int len;
char *pre;
{
    char *cp, c, **av = NULLVP, *string;
    int s_len, p_len = 0;

    if (str == NULLCP)
	return(NULLVP);

    if (len > (s_len = strlen(str)) || *str == NULLC)
	return(add2av(av, add2cp(NULLCP, str)));

    /* pre may very well be NULLCP or a NULLC */

    if (pre == NULLCP)
	pre = "";
    p_len = strlen(pre);

    for ( ; len < s_len + p_len; s_len -= (cp - str), str = cp) {

	cp = str + len;
	if (av != NULLVP)
	    cp -= p_len;

	while (p_len && !strncmp(cp, pre, p_len)) 
	    if ((cp -= p_len) <= str) {
		string = NULLCP;
		if (av != NULLVP) 
		    string = add2cp(string, pre);
		string = add2cp(string, str);
		av = add2av(av, string);
		return(av);
	    }

	c = *cp;
	*cp = NULLC;
	string = NULLCP;
	if (av != NULLVP) 
	    string = add2cp(string, pre);
	string = add2cp(string, str);
	av = add2av(av, string);
	*cp = c;
    }

    if (s_len >  0) {
	string = NULLCP;
	if (av != NULLVP) 
	    string = add2cp(string, pre);
	string = add2cp(string, str);
	av = add2av(av, string);
    }

    return(av);
}
