/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"

static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

static struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(inputfd));
}

static user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd, bb));
}

static error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd, bb));
}

main(argc, argv)
int argc;
char **argv;
{
    char            **av = NULLVP,
                    **avptr = NULLVP,
                    **user = NULLVP;
    char             *pu = NULLCP;
    struct bbuf      *pw = NULLBB,
                     *privkey = NULLBB;
    struct cbstruct   iocbs;
    int               keystatus;

    if (pem_init(argc, argv, &av) != OK) {
	(void) fprintf(stderr, "%s: initialization failure\n", *argv);
	exit(1);
    }

    if (argc > 1 && !strcmp(*(argv+1), "help")) {
	(void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
	(void) fprintf(stderr, "Usage: %s %s\n", myname, "[alias <alias>]");
	exit(1);
    }

    /* initialize callbacks */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.in_user = user_in;
    iocbs.ne_user = user_ne;
    iocbs.out_user = user_out;
    iocbs.out_errs = error_out;

    /* user record to change */

    rewind_indexfile();

    if (av == NULLVP) {
	if ((avptr = tag_user(user_tailor, "sig-alias")) == NULLVP) {
            (void) fprintf(stderr, "Unable to determine sig-alias alias.\n");
            exit(1);
	}
	if ((user = get_tv_user("alias", *(avptr+1))) == NULLVP) {
            (void) fprintf(stderr, 
	   "Unable to find user with sig-alias alias \"%s\".\n",
			   *(avptr+1));
            exit(1);
	}
    }
    else if ((user = get_tvt_user(av)) == NULLVP) {
	(void) fprintf(stderr, 
		       "Unable to find user matching supplied template.\n");
	exit(1);
    }

    pu = pretty_user(user);
    fprintf (stderr, "Changing password for %s\n", pu);
    FREE(pu);

    while ((keystatus = get_key(user, pw, &privkey)) != OK) {
	if (keystatus == NOTOK) {
	    (void) fprintf(stderr, "Unable to access private key.\n");
	    exit(1);
	}
	(void) fprintf(stdout, "\nEnter old password for private key.\n");
	if ((pw = get_password(&iocbs, 0)) == NULLBB) {
	    (void) fprintf(stderr, "Password NOT changed.\n");
	    exit(1);
	}
    }

    (void) fprintf(stdout, "\nEnter new password for private key.\n");
    pw = get_password(&iocbs, 1);

    if (sav_key(user, pw, privkey) != OK) {
	(void) fprintf(stderr,
		       "Unable to save private key.\nPassword NOT change.\n");
	exit(1);
    }

    (void) fprintf(stdout, "Password changed.\n");

    exit(0);
}
