/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "new.h"
#include "user_list.h"
#include "util.h"

static int fd_datain = 0;
static int fd_dataout = 1;
static int fd_hdrout = 2;
static int fd_errout = 2;

static int fd_userout = -1;
static int fd_userne = -1;

static struct bbuf *data_in()
{
    return(cbfdread(fd_datain));
}

static int data_out(buf)
struct bbuf *buf;
{
    return(cbfdwrite(fd_dataout, buf));
}

static int header_out(buf)
struct bbuf *buf;
{
    return(cbfdwrite(fd_hdrout, buf));
}

static error_out(bbuf)
struct bbuf *bbuf;
{
    return(cbfdwrite(fd_errout, bbuf));
}

static user_out(bbuf)
struct bbuf *bbuf;
{
    return(cbfdwrite(fd_userout, bbuf));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(fd_userne));
}


main(argc, argv)
int	argc;
char	**argv;
{
    struct cbstruct    iocbs;
    FILE	      *dinfile = (FILE *)0,
		      *doutfile = (FILE *)0,
		      *houtfile = (FILE *)0;
    char	     **origalias = NULLVP,
		     **origuser = NULLVP,
		     **recipuser = NULLVP,
		     **localopts = NULLVP,
		     **fileopt = NULLVP,
		     **aliasopt = NULLVP,
		     **dekalgopt = NULLVP,
                     **metooopt = NULLVP,
                     **mealiasopt = NULLVP,
                       *pu = NULLCP;
    struct user_list  *reciplist = NULLUL,
                      *tmplist = NULLUL;
    int                bad_recip = 0,
                       fail = 0,
                       arg,
                       ret = NOTOK;
    struct bbuf       *privkey = NULLBB,
                      *pw = NULLBB;

    /*  Initialize TIS/PEM  */

    if (pem_init(argc, argv, &localopts) != OK) {
	(void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
	goto cleanup;
    }

    /* Process arguments */

    if (tag_user(localopts, "alias") == NULLVP || 
	(argc >  2 && !strcasecmp(argv[1], "help"))) {
	(void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
	(void) fprintf(stderr, "Usage: %s %s %s %s\n",
		       myname, "alias <alias> ... [metoo yes|no]",
		       "[data-in <filename>] [data-out <filename>]",
		       "[header-out <filename>]");
	exit(1);
    }

    if ((fileopt = tag_user(localopts, "data-in")) != NULLVP)
        if ((dinfile = fopen(*(fileopt+1), "r")) != (FILE *)0) 
            fd_datain = fileno(dinfile);
        else {
            fprintf(stderr, "%s: unable to open data-in file %s\n",
                    myname, *(fileopt+1));
            goto cleanup;
        }

    if ((fileopt = tag_user(localopts, "data-out")) != NULLVP)
        if ((doutfile = fopen(*(fileopt+1), "w")) != (FILE *)0) 
            fd_dataout = fileno(doutfile);
        else {
            fprintf(stderr, "%s: unable to open data-out file %s\n",
                    myname, *(fileopt+1));
            goto cleanup;
        }

    if ((fileopt = tag_user(localopts, "header-out")) != NULLVP)
        if ((houtfile = fopen(*(fileopt+1), "w")) != (FILE *)0) 
            fd_hdrout = fileno(houtfile);
        else {
            fprintf(stderr, "%s: unable to open header-out file %s\n",
                    myname, *(fileopt+1));
            goto cleanup;
        }

    dekalgopt = tag_user(user_tailor, "dek-alg");

    /* get list of encrypt-alias recipients if metoo is set */

    if ((metooopt = tag_user(user_tailor, "metoo")) != NULLVP &&
	!strcasecmp(*(metooopt+1), "yes")) {
	if ((mealiasopt = tag_user(user_tailor, "encrypt-alias")) == NULLVP) {
	    fprintf(stderr, "%s: Unable to determine encrypt-alias\n", myname);
            goto cleanup;
	}
        rewind_indexfile();
	while ((recipuser = get_tv_user("alias", *(mealiasopt+1))) != NULLVP) {
            if (dinfile != (FILE *)0 && doutfile != (FILE *)0) {
                pu = pretty_user(recipuser);
                printf("Encrypting for me as %s.\n", pu);
                FREE(pu);
            }
	    tmplist = alloc_ul();
            tmplist->user = recipuser;
            tmplist->next = reciplist;
            reciplist = tmplist;
            tmplist = NULLUL;
	}
    }

    /* get user-supplied list of recipients */

    for (aliasopt = localopts;
	 (aliasopt = tag_user(aliasopt, "alias")) != NULLVP;
	 aliasopt += 2) {
        rewind_indexfile();
	bad_recip = 1; 
        while ((recipuser = get_tv_user("alias", *(aliasopt+1))) != NULLVP) {
	    if (dinfile != (FILE *)0 && doutfile != (FILE *)0) {
		pu = pretty_user(recipuser);
                printf("Encrypting for %s.\n", pu);
		FREE(pu);
	    }
	    bad_recip = 0;
	    tmplist = alloc_ul();
	    tmplist->user = recipuser;
	    tmplist->next = reciplist;
	    reciplist = tmplist;
	    tmplist = NULLUL;
	}
	if (bad_recip) {
	    (void) fprintf(stderr, "%s: unable to map alias %s to user\n", 
			   myname, *(aliasopt+1));
	    fail = 1;
	}
    }

    if (fail)
	goto cleanup;

    if (reciplist == NULLUL) {
	(void) fprintf(stderr, "%s: No recipient aliases provided\n", myname);
	goto cleanup;
    }

    /*  Get user's certificate (for PRNG initialization) */

    rewind_indexfile();
    if ((origalias = tag_user (user_tailor, "sig-alias")) == NULLVP) {
        (void) fprintf(stderr, "%s: No sig-alias for PRNG init", myname);
	goto cleanup;
    }
    if ((origuser = get_tv_user ("alias", *(origalias+1))) == NULLVP) {
	(void) fprintf(stderr, 
		       "%s: Can't find sig-alias user %s for PRNG init\n", 
		       myname, *(origalias+1));
	goto cleanup;
    }
  
    /* Set up callback structure */

    BZERO (&iocbs, sizeof (struct cbstruct));
    iocbs.in_data = data_in;
    iocbs.out_data = data_out;
    iocbs.out_hdrs = header_out;
    iocbs.out_errs = error_out;

    if (dinfile != (FILE *)0 && doutfile != (FILE *)0) {
	fd_userout = 1;
	fd_userne = 0;
	iocbs.out_user = user_out;
	iocbs.ne_user = user_ne;
    }

    /* get the private key so we can initialize the PRNG */

 pwagain:
    switch (get_key(origuser, pw, &privkey)) {
    case OK:
	/* great, no problems */
	break;

    case EINVAL:
	/* incorrect password entered */
	if (pw != NULLBB) {
	    fprintf(stdout, "\nIncorrect password.  Try again.");
	    FREE_BBUF(pw);
	}

	/* okay, we need password; can we get it */
	if ((pw = get_password(&iocbs, 0)) == NULLBB)
	    goto cleanup;
	goto pwagain;

    case NOTOK:
	/* who knows; the originator loses */
	fprintf(stderr,
		"%s: Unable to access private key of user %s for PRNG init\n",
		myname, *(origalias+1));
	goto cleanup;
    }

    /* set private key for PRNG */

    if (privkey != NULLBB) 
	if (set_key(privkey) != OK) {
	    (void) fprintf(stderr,
		   "Unable to set private key for PRNG initialization.\n",
		    *(origalias+1));
	    goto cleanup;
	}

    /* Initialize PRNG */

    if (initprng(origuser)) {
	(void) fprintf(stderr,
		       "Unable to initialize PRNG using sig-alias user %s.\n",
		       *(origalias+1));
	goto cleanup;
    }

    /* Perform the encryption */

    if (pem_encrypt(reciplist, DES_CBC, &iocbs)) {
	(void) fprintf(stderr, "%s: Unable to encrypt message.\n", myname);
	goto cleanup;
    }
    ret = OK;

 cleanup:

    if (dinfile != (FILE *)0)
	(void)fclose(dinfile);
    if (doutfile != (FILE *)0)
	(void)fclose(doutfile);
    if (houtfile != (FILE *)0)
	(void)fclose(houtfile);

    exit(ret);
}

/****************************************************************************/
