/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"

#include <stdio.h>

#include "general.h"

#include "bbuf.h"
#include "util.h"

struct bbuf *cbmemread(array)
char *array;
{
    struct bbuf *buf;

    buf = alloc_bbuf();
    buf->data = alloc_uchar(sizeof (array));
    buf->length = sizeof(array);
    BCOPY(array, buf->data, buf->length);

    return (buf);
}

int cbmemwrite(buf, array)
struct bbuf *buf;
char **array;
{
    if (buf == NULLBB)
	return(0);

    if (array == NULLVP)
	return(1);

    if (buf->length == 0)
	return(1);
  
    if (buf->data == NULLUCP)
	return(0);

    if (*array == NULL) 
	*array = alloc_char(buf->length);
    else {
	if ((*array = realloc(*array,
			      (unsigned)(sizeof(*array) + buf->length)))
	    == NULLCP)
	    return(0);
    }

    BCOPY(buf->data, *array + sizeof(*array) - buf->length, buf->length);
    return (1);
}
