/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * decode_rtbs.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

int decode_rtbs(etbs, dtbs, rlength)
struct bbuf *etbs;
struct crltobesigned **dtbs;
int *rlength;
{
    int length, llen, dnllen;
    int dp, pl;
    struct bbuf *bb = NULLBB;
    int r = OK;

    /* CHECK PARAMETERS */
    if (etbs == (struct bbuf *)0) 
	return(NOTOK);

    if (dtbs == (struct crltobesigned **)0) 
	return(NOTOK);

    if (*dtbs != NULL_CRLTOBESIGNED) {
	(void) free_crltobesigned(*dtbs);
	*dtbs = NULL_CRLTOBESIGNED;
    }
    if (rlength == (int *)0) 
	return(NOTOK);

    /* CHECK FOR ENCODED DATA */
    if (etbs->data == (unsigned char *)0) {
        return(NOTOK);
    }
    if (etbs->length < 2) 
        return(ASN1_ERR01);

    /* CHECK FOR UNIVERSAL CONSTRUCTED SEQUENCE */
    if (etbs->data[0] != (CLASS_UNIV|FORM_CONS|CONS_SEQ)) 
        return(ASN1_ERR02);

    /* GET LENGTH */
    if ((r = decode_len(&(etbs->data[1]), etbs->length-1, &length, &llen))
	!= OK)
	return(r);
    *rlength = 1 + llen + length;

    /* CHECK FOR NULL */
    if (!length)
	return(OK);

    /* ALLOCATE CRL TOBESIGNED */
    *dtbs = alloc_crltobesigned();
	
    /* ALLOCATE TEMPORARY BBUF */
    bb = alloc_bbuf();

    /* DECODE SIGNATURE ALGORITHM */
    dp = 1 + llen;
    bb->data = &(etbs->data[dp]);
    bb->length = 1 + llen + length - dp;
    if ((r = decode_algid(bb, &((*dtbs)->sig_alg), &pl)) != OK)
	goto cleanup;

    /* DECODE ISSUER DNAME */
    dp += pl;
    bb->data = &(etbs->data[dp]);
    slen = bb->length;
    if ((r=decode_len(&(etbs->data[dp+1]), 1+llen+length-dp,
                      &slen, &dnllen)) != OK) {
	bb->length = (short)slen;
        goto cleanup;
    }
    bb->length = slen+1+dnllen;
    if (bb->length && ((*dtbs)->issuer=dup_bbuf(bb)) == NULLBB) {
        r = NOTOK;
        goto cleanup;
    }
    pl = bb->length;

    /* DECODE LASTUPDATE */
    dp += pl;
    bb->data = &(etbs->data[dp]);
    bb->length = 1 + llen + length - dp;
    if ((r = decode_utct(bb, &((*dtbs)->lastupdate), &pl)) != OK)
	goto cleanup;

    /* DECODE NEXTUPDATE */
    dp += pl;
    bb->data = &(etbs->data[dp]);
    bb->length = 1 + llen + length - dp;
    if ((r = decode_utct(bb, &((*dtbs)->nextupdate), &pl)) != OK)
	goto cleanup;

    /* DECODE REVOKED CERTIFICATE LIST */
    dp += pl;
    bb->data = &(etbs->data[dp]);
    bb->length = 1 + llen + length - dp;
    if (!bb->length)		/* RCL IS ABSENT */
	r = OK;
    else if ((r = decode_rcl(bb, &((*dtbs)->rcl), &pl)) != OK)
	goto cleanup;
    else;
    /* r = OK; */

 cleanup:

    if (bb != NULLBB) {
        bb->data = (unsigned char *)0;
        (void) free_bbuf(bb);
    }

    if (r != OK) {
	(void) free_crltobesigned(*dtbs);
	*dtbs = NULL_CRLTOBESIGNED;
    }

    return(r);
}

/*****************************************************************************/
