/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

free_crl(crl)
struct crl *crl;
{
    if (crl == NULL_CRL)
	return(OK);

    FREE_CRLTOBESIGNED(crl -> tobesigned);
    FREE_ALGID(crl -> sig_alg);
    FREE_BBUF(crl -> sig);

    (void) free((char *)crl);
    return(OK);
}

free_crltobesigned(t)
struct crltobesigned *t;
{
    if (t == NULL_CRLTOBESIGNED)
	return(OK);

    FREE_ALGID(t -> sig_alg);
    FREE_BBUF(t -> issuer);
    FREE_RCL(t -> rcl);

    (void) free((char *)t);
    return(OK);
}

free_rcl(v)
struct rcl_entry *v;
{
    struct rcl_entry *ptr = NULL_RCL_ENTRY;

    while (v != NULL_RCL_ENTRY) {
	ptr = v -> next;
	(void) free((char *)v);
	v = ptr;
    }

    return(OK);
}
